/* ccgo: igs/datetime.cc
 *
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#define _XOPEN_SOURCE 1
#ifndef _GNU_SOURCE
#define _GNU_SOURCE 1
#endif
#include "datetime.hh"
#include <glibmm/convert.h>
#include <ctime>
#include <cstdlib>

using namespace igs;

Datetime::Datetime()
{
	sec = -1;
}

Datetime::Datetime(const std::string & s)
{
	set(s);
}

void Datetime::set(const std::string & s)
{
	tm tt;
	strptime(s.c_str(), "%a %b %d %T %Y", & tt);

#ifdef HAVE_TIMEGM
	time_t p = timegm(& tt) - 9 * 60 * 60; // time zone for IGS
#else // implementation from the man page of timegm
	time_t p;
	char * tz;
	tz = getenv("TZ");
	setenv("TZ", "", 1);
	tzset();
	p = mktime(& tt);
	if (tz) setenv("TZ", tz, 1);
	else unsetenv("TZ");
	tzset();
#endif
	localtime_r(& p, & tt); // convert to localtime
	sec = tt.tm_sec;
	min = tt.tm_min;
	hour = tt.tm_hour;
	day = tt.tm_mday;
	mon = tt.tm_mon + 1;
	year = tt.tm_year + 1900;
}

Datetime::operator bool() const
{
	return sec >= 0;
}

Glib::ustring Datetime::to_str() const
{
	char buf[100];
	tm tt;
	tt.tm_sec = sec;
	tt.tm_min = min;
	tt.tm_hour = hour;
	tt.tm_mday = day;
	tt.tm_mon = mon - 1;
	tt.tm_year = year - 1900;
	time_t p = mktime(& tt);
	localtime_r(& p, & tt);
// 	strftime(buf, sizeof(buf), "%Y-%m-%d %H:%M:%S", & tt);
	char fm[] = "%c"; // warning fix...
	// some locale uses two-digit year is the problem of that locale, not gcc!
	strftime(buf, sizeof(buf), fm, & tt);
	return Glib::locale_to_utf8(std::string(buf));
}
