/* ccgo: igs/custom_text.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_CUSTOM_TEXT_HH
#define IGS_CUSTOM_TEXT_HH
#include <gtkmm/treeview.h>
#include <string>

class CustomText
{
public:
	virtual ~CustomText() {}
	virtual const std::string & get_text() const = 0;
	virtual bool operator < (const CustomText &) const = 0;
	class CellRenderer :
		public Gtk::CellRendererText
	{
		void render_vfunc(const Glib::RefPtr<Gdk::Drawable> &, Gtk::Widget &, const Gdk::Rectangle &, const Gdk::Rectangle &, const Gdk::Rectangle &, Gtk::CellRendererState);
	};
	static gint compare(const Gtk::TreeModel::iterator &, const Gtk::TreeModel::iterator &, Gtk::TreeModelColumn<void *>);
	static gint null_compare(const Gtk::TreeModel::iterator &, const Gtk::TreeModel::iterator &);
};
#endif // IGS_CUSTOM_TEXT_HH
