/* ccgo: igs/custom_text.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "custom_text.hh"

void CustomText::CellRenderer::render_vfunc(const Glib::RefPtr<Gdk::Drawable> & window, Gtk::Widget & widget, const Gdk::Rectangle & background_area, const Gdk::Rectangle & cell_area, const Gdk::Rectangle & expose_area, Gtk::CellRendererState flags)
{
	CustomText * m = (CustomText *) property_user_data().get_value();
	// std::cerr << m << std::endl;
	if (m) property_text().set_value(m->get_text());
	else property_text().set_value("");
	Gtk::CellRendererText::render_vfunc(window, widget, background_area, cell_area, expose_area, flags);
}

gint CustomText::compare(const Gtk::TreeModel::iterator & a, const Gtk::TreeModel::iterator & b, Gtk::TreeModelColumn<void *> col)
{
	// Gtk::TreeModel::Row row1 = * a;
	// Gtk::TreeModel::Row row2 = * b;
	void * v1 = (* a)[col];
	void * v2 = (* b)[col];
	CustomText * m1 = (CustomText *) v1;
	CustomText * m2 = (CustomText *) v2;
	if (! (m1 && m2)) return 0;
	if (* m1 < * m2) return 1;
	if (* m2 < * m1) return -1;
	return 0;
}

gint CustomText::null_compare(const Gtk::TreeModel::iterator &, const Gtk::TreeModel::iterator &)
{
	return 0;
}
