/* ccgo: igs/control.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_CONTROL_HH
#define IGS_CONTROL_HH
#include "connect.hh"
#include "parser/parser.hh"
#include "player.hh"
#include "game.hh"
#include "result.hh"
#include "../move.hh"
#include "storage.hh"
#include "odds.hh"
#include "match.hh"
#include "board.hh"
#include <vector>
namespace igs
{
	enum PromptType {
		PROMPT_NORMAL = 0,
		PROMPT_MATCH,
		PROMPT_SCORE,
		PROMPT_OBSERVE
	};

	enum ToggleType {
		TOGGLE_BELL,
		TOGGLE_QUIET,
		TOGGLE_SHOUT,
		TOGGLE_AUTOMAIL,
		TOGGLE_OPEN,
		TOGGLE_LOOKING,
		TOGGLE_KIBITZ,
		TOGGLE_CHATTER,
		TOGGLE_SINGLEGAME,
		// the following should be fixed
		TOGGLE_VERBOSE,
		TOGGLE_CLIENT
	};

	class Control :
		virtual public sigc::trackable
	{
		Connect * conn;
		void process_line(const std::string &);
		bool check_prompt(const std::string &);

		Parser * parser;
		std::string line_buffer;
		int num_cmd;
		std::string cmd_dat;
		static void _conn_lost(Control *);
	protected:
		// virtual void conn_lost();
		virtual void conn_lost();
		bool is_conn();
	public:
		Control();
		virtual ~Control();
		bool open();
		void close();

		void send_line(const std::string &);

		const std::string & get_line() const;
		int get_num_cmd();
		const std::string & get_cmd_dat();

		// the IGS interface
		virtual void cancel_conn();
		virtual void client_ready();
		virtual void set_prompt(PromptType);
		virtual void set_username(const std::string &);
		virtual void do_beep();
		virtual void add_message(const std::string &);
		virtual void add_tagged_message(const std::string &, const std::string &);
		virtual void player_update(const Player &);
		virtual void player_stats(const Player &);
		virtual void player_odds(const Odds &);
		virtual void player_end_update();
		virtual void game_result(const std::vector<Result> &);
		virtual void stored_game(const std::vector<Storage> &);
		virtual void game_update(const Game &);
		virtual void game_end_update();
		virtual void game_move(go::Move *, int = 0);
		virtual void game_undo(int = 0);
		virtual void game_time(int, int, int, int, int);
		virtual void game_title(int, const std::string &);
		virtual void ob_remove(int);
		virtual void game_finish(int, const std::string &);

		virtual void match_score(int = 0);
		virtual void match_restore(int = 0);
		virtual void match_remove(const go::Loc &, int = 0);
		virtual void match_adjourn(int = 0);
		virtual void match_finish(const std::string &, int = 0);
		virtual void match_message(const std::string &, int = 0);

		virtual void match_resign(const std::string &);
		virtual void match_timeup(const std::string &);
		virtual void remove_match(const std::string &, const std::string &);

		virtual void player_update(const std::string &, const std::string &);
		virtual void player_remove(const std::string &);

		virtual void message_sys(const std::string &);
		virtual void message_tell(const std::string &);
		virtual void message_tell(const std::string &, const std::string &);
		virtual void message_yell(const std::string &);
		virtual void message_kibitz(int, const std::string &);
		virtual void message_misc(const std::string &);

		virtual void match_request(const Match &);
		virtual void match_create(int, const std::string &);
		virtual void match_decline(const std::string &);
		virtual void match_not_online(const std::string &);
		virtual void match_not_open();
		virtual void match_in_match(const std::string &);
		virtual void game_board(const Board &);

		virtual void toggle_state(ToggleType, bool);
		virtual void file_text(const std::string &);
	};
}
#endif // IGS_CONTROL_HH
