/* ccgo: igs/control.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "control.hh"
#include "parser/init.hh"
#include "../settings.hh"
#include "fork.hh"
#include "sock.hh"
#include <sstream>
#include <iostream>

using namespace igs;

void Control::process_line(const std::string & s)
{
	line_buffer = s;
	if (go::settings.get_option(go::Settings::OPT_DUMP_IGS)) std::cout << s << std::endl;
	num_cmd = -1;
	if (parser) {
		if (parser->process()) return;
		delete parser;
		parser = 0;
	} else if (line_buffer == "") return; // won't skip empty line when a parser is in effect
	parser = Parser::search_id(this);
}

bool Control::check_prompt(const std::string & s)
{
	if (s.length() < 3) return false;
	std::string e = s.substr(s.length() - 3);
	if (e == "#> " || e == "n: " || e == "d: ") return true;
	return false;
}

void Control::_conn_lost(Control * c) // to work around a segmentation fault...
{
	c->close();
	c->conn_lost();
}

void Control::conn_lost()
{
}

bool Control::is_conn()
{
	return conn;
}

Control::Control() :
	conn(0),
	parser(0)
{
}

Control::~Control()
{
	if (parser) delete parser;
	close();
}

bool Control::open()
{
	if (go::settings.get_option(go::Settings::OPT_IGS_DIRECT)) {
		conn = new Sock(go::settings.get_igs_host(), go::settings.get_igs_port());
	} else {
		conn = new Fork(go::settings.get_igs_telnet());
	}
	conn->recv_line.connect(mem_fun(* this, & Control::process_line));
// 	conn->conn_lost.connect(mem_fun(* this, & Control::conn_lost));
	conn->conn_lost.connect(bind(ptr_fun(& Control::_conn_lost), this));
	conn->check_prompt.connect(mem_fun(* this, & Control::check_prompt));

	if (! conn->is_ok()) {
		close();
		return false;
	}
	Parser::init_parser_list();
	parser = new parser::Init(this);
	return true;
}

void Control::close()
{
	if (conn) {
		delete conn;
		conn = 0;
	}
}

void Control::send_line(const std::string & s)
{
	conn->send_line(s);
	if (go::settings.get_option(go::Settings::OPT_DUMP_IGS)) std::cout << s << std::endl;
}

const std::string & Control::get_line() const
{
	return line_buffer;
}

int Control::get_num_cmd()
{
	if (num_cmd < 0) {
		std::istringstream s(line_buffer);
		s >> num_cmd;
		if (num_cmd < 0) return num_cmd = 0;

		unsigned i = 0;
		while (i < line_buffer.length()) {
			if (line_buffer[i] < '0' || line_buffer[i] > '9') break;
			i ++;
		}
		cmd_dat = line_buffer.substr(i + 1);
	}
	return num_cmd;
}

const std::string & Control::get_cmd_dat()
{
	return cmd_dat;
}

void Control::cancel_conn()
{
}

void Control::client_ready()
{
}

void Control::set_prompt(PromptType p)
{
}

void Control::set_username(const std::string &)
{
}

void Control::do_beep()
{
}

void Control::add_message(const std::string &)
{
}

void Control::add_tagged_message(const std::string & tag, const std::string & text)
{
}

void Control::player_update(const Player &)
{
}

void Control::player_stats(const Player &)
{
}

void Control::player_odds(const Odds &)
{
}

void Control::player_end_update()
{
}

void Control::game_result(const std::vector<Result> &)
{
}

void Control::stored_game(const std::vector<Storage> &)
{
}

void Control::game_update(const Game &)
{
}

void Control::game_end_update()
{
}

void Control::game_move(go::Move * mv, int g)
{
	// std::cerr << "game " << g << ": " << mv->as_string() << std::endl;
}

void Control::game_undo(int)
{
}

void Control::game_time(int g, int wt, int wm, int bt, int bm)
{
}

void Control::game_title(int g, const std::string &)
{
}

void Control::ob_remove(int)
{
}

void Control::game_finish(int, const std::string &)
{
}

void Control::match_score(int)
{
}

void Control::match_restore(int)
{
}

void Control::match_remove(const go::Loc &, int)
{
}

void Control::match_adjourn(int)
{
}

void Control::match_finish(const std::string &, int)
{
}

void Control::match_message(const std::string &, int)
{
}

void Control::match_resign(const std::string &)
{
}

void Control::match_timeup(const std::string &)
{
}

void Control::remove_match(const std::string &, const std::string &)
{
}

void Control::player_update(const std::string &, const std::string &)
{
}

void Control::player_remove(const std::string &)
{
}

void Control::message_sys(const std::string &)
{
}

void Control::message_tell(const std::string &)
{
}

void Control::message_tell(const std::string &, const std::string &)
{
}

void Control::message_yell(const std::string &)
{
}

void Control::message_kibitz(int, const std::string &)
{
}

void Control::message_misc(const std::string &)
{
}

void Control::match_request(const Match &)
{
}

void Control::match_create(int, const std::string &)
{
}

void Control::match_decline(const std::string &)
{
}

void Control::match_not_online(const std::string &)
{
}

void Control::match_not_open()
{
}

void Control::match_in_match(const std::string &)
{
}

void Control::game_board(const Board &)
{
}

void Control::toggle_state(ToggleType, bool)
{
}

void Control::file_text(const std::string &)
{
}
