/* ccgo: igs/connect.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_CONNECT_HH
#define IGS_CONNECT_HH
#include <sigc++/object.h>
#include <sigc++/signal.h>
#include <glibmm/refptr.h>
#include <glibmm/object.h>
#include <string>
namespace igs
{
	class Connect :
		virtual public sigc::trackable
	{
	protected:
		bool connect_ok;
	public:
		Connect();
		virtual ~Connect();
		virtual void send_line(const std::string &);
		sigc::signal<void, const std::string &> recv_line; // line received
		sigc::signal<void> conn_lost;
		bool is_ok();
		sigc::signal<bool, const std::string &> check_prompt; // check if an unfinished line is a prompt
	};
}
#endif // IGS_CONNECT_HH
