/* ccgo: igs/board.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IGS_BOARD_HH
#define IGS_BOARD_HH
#include "datetime.hh"
#include <go.hh>
#include <string>

namespace igs
{
	class Board
	{
	public:
		enum StopType {
			STOP_UNKNOWN,
			STOP_ADJOURN,
			STOP_DISCONNECT
		};

		class Record
		{
			go::Turn who;
			StopType stop;
		public:
			Record();
			void set(const std::string &);
			Glib::ustring to_str() const;
			operator bool() const;
		};

		std::string white;
		int w_cap;
		int w_time;
		int w_stones;
		std::string black;
		int b_cap;
		int b_time;
		int b_stones;
		double komi;
		int handicap;
		int board_size;
		int * state;

		bool is_score;
		std::string score;
		Datetime date;
		Record record;
		// std::string record;

		Board();
		~Board();
		void set_size(int);
		int & site(int, int);
		const int & site(int, int) const;
	};
}
#endif // IGS_BOARD_HH
