/* ccgo: igs/board.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "../config.hh"
#include "../gettext.h"
#include "board.hh"
#include <glibmm/convert.h>

#include <cstdio>
#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace igs;

Board::Record::Record() :
	stop(STOP_UNKNOWN)
{
}

void Board::Record::set(const std::string & s)
{
	if (s.substr(0, 5) == "White") who = go::TURN_WHITE;
	else if (s.substr(0, 5) == "Black") who = go::TURN_BLACK;
	else return;

	if (s.substr(6, 7) == "disconn") stop = STOP_DISCONNECT;
	else if (s.substr(6, 7) == "adjourn") stop = STOP_ADJOURN;
}

Glib::ustring Board::Record::to_str() const
{
	Glib::ustring w = (who == go::TURN_WHITE ? _("White") : _("Black"));
	char buf[100];
	if (stop == STOP_DISCONNECT) snprintf(buf, 100, _("%s disconnected from the game.").c_str(), w.c_str());
	else if (stop == STOP_ADJOURN) snprintf(buf, 100, _("%s adjourned the game.").c_str(), w.c_str());
	else snprintf(buf, 100, "%s", _("The game is not marked.").c_str());
	return buf;
}

Board::Record::operator bool() const
{
	return stop != STOP_UNKNOWN;
}

Board::Board() :
	board_size(0),
	state(0),
	is_score(false)
{
}

Board::~Board()
{
	if (state) delete[] state;
}

void Board::set_size(int z)
{
	board_size = z;
	if (state) delete[] state;
	state = new int[z * z];
}

int & Board::site(int x, int y)
{
	return state[board_size * y + x];
}

const int & Board::site(int x, int y) const
{
	return state[board_size * y + x];
}
