/* ccgo: handicap.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef HANDICAP_HH
#define HANDICAP_HH
#include "move.hh"
#include <string>
namespace go {
	class Handicap :
		public Move
	{
		std::vector<Loc> handi;
	public:
		Handicap(unsigned);
		Handicap(const std::vector<Loc> &);
		Handicap(const Handicap &);
		Modifi * dup() const;
		bool check(const Game &);
		virtual void apply(Game &) const;
		virtual void undo(Game &) const;
		virtual std::string as_string() const;
		const std::vector<Loc> get_handi() const;
	};
}
#endif // HANDICAP_HH
