/* ccgo: handicap.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "handicap.hh"
#include <sstream>

using namespace go;

Handicap::Handicap(unsigned h) :
	Move(TURN_BLACK)
{
	// only works with 19x19 games...
	handi.clear();
	static const int hx[] = {3, 15, 3, 15, 3, 15, 9, 9};
	static const int hy[] = {3, 15, 15, 3, 9, 9, 3, 15};
	if (h > 4 && h % 2 == 1) {
		-- h;
		handi.push_back(Loc(9, 9));
	}
	for (unsigned i = 0; i < h; i ++) handi.push_back(Loc(hx[i], hy[i]));
}

Handicap::Handicap(const std::vector<Loc> & l) :
	Move(TURN_BLACK)
{
	handi = l;
}

Handicap::Handicap(const Handicap & m) :
	Move(m)
{
	handi = m.handi;
}

Modifi * Handicap::dup() const
{
	return new Handicap(* this);
}

bool Handicap::check(const Game & g)
{
	if (! Move::check(g)) return checked = false;
	if (num != 1) return checked = false;
	if (g.get_board_size() != 19) return checked = false;
	return true;
}

void Handicap::apply(Game & g) const
{
	if (! checked) return;
	Move::apply(g);
	for (std::vector<Loc>::const_iterator i = handi.begin(); i != handi.end(); ++ i) g.set_site(* i, STATE_BLACK);
}

void Handicap::undo(Game & g) const
{
	for (std::vector<Loc>::const_iterator i = handi.begin(); i != handi.end(); ++ i) g.set_site(* i, STATE_EMPTY);
	Move::undo(g);
}

std::string Handicap::as_string() const
{
	std::ostringstream s;
	s << num << ". B: Handicap " << handi.size();
	return s.str();	
}

const std::vector<Loc> Handicap::get_handi() const
{
	return handi;
}
