/* ccgo: go/gtk/gtk.hh
 * 
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_GTK_GTK_HH
#define GO_GTK_GTK_HH

#include "board.hh"
#include "gmap.hh"
#include <go/game0.hh>
#include <go/list.hh>

#include <gtkmm/paned.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/textview.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/fileselection.h>
#include <gtkmm/checkmenuitem.h>
#include <gtkmm/uimanager.h>

namespace gtk {
	class MarkWin : // window for selecting a mark for a site
		public Gtk::Window
	{
	public:
		MarkWin();
		void show_win(int x, int y, std::string loc = "");
		void set_mark(ccgo::Mark marking);
		void set_label(std::string label);
		ccgo::Mark get_mark();
		const std::string & get_label();
	protected:
		void select_mark(ccgo::Mark marking);
		void enter_label();
	private:
		ccgo::Mark m;
		std::string l;
		std::vector<Gtk::RadioButton *> rbs;
		Gtk::Entry et;
	};

	class View : // main game viewing window
		public Gtk::Window,
		virtual public ccgo::PathWalk
	{
	public:
		View();
		~View();
		virtual void set_node(ccgo::Node * node);
		virtual void up();
		virtual void down(unsigned index);
		virtual void down(ccgo::Node * node);
		virtual void do_geom();
		void set_list(ccgo::List * list);
	protected:
		virtual void on_realize();
		virtual bool on_configure_event(GdkEventConfigure * event);
		virtual void on_size_allocate(Gtk::Allocation & allocation);

		virtual void clear();
		virtual void set_state(int loc, State state);
// 		virtual void set_ko(const std::set<int> & ko);
	private:
		enum Mode {
			MODE_VIEW = 0,
			MODE_INIT = 1,
			MODE_PLAY = 2,
			MODE_MARK = 3,
			MODE_SETUP = 4,
			MODE_SCORE = 5,
			MODE_UNKNOWN
		};

		void toggle_mark_last();
		void toggle_show_ko();
		void set_max_depth();
		void depth_change();
		void set_alternative();
		void alternative_left();
		void alternative_right();
		void board_clicked(int loc);
		void delete_moves();
		void create_node();
		void do_old_node();
		void do_new_node();
		void paned_moved(Gtk::Allocation & allocation);
		void map_toggle();
		void map_hide();
		bool map_handle_draw(GdkEventExpose * event);
		void draw_map_handle();
		void select_node(ccgo::Node * node);

		void file_open();
		void file_save();

		void game_pass();
		void game_handicap(int num_stones);
		void game_mode(Mode new_mode);
		void game_turn_change();

		void mark_set();
		void clear_marks();
		void do_score()
;
		void check_list();
		void list_select(unsigned index);

		gtk::Board * b;

		// some display properties
		bool mark_last; // mark last move?
		bool show_ko; // show ko?

		Gtk::Label dp; // branch depth
		// Glib::RefPtr<Gtk::Adjustment> prog; // progression
		Gtk::Adjustment * prog;
		Gtk::Button btL;
		Gtk::Button btR;
		Gtk::ToggleButton btM;
		Gtk::DrawingArea daM;
		Gtk::OptionMenu o_mode;
		Gtk::OptionMenu o_turn;

		MapWin mw;

		Gtk::TextView tv;
		Gtk::VPaned vp;

		int sv_w; // saved width
		int sv_h; // saved height
		int sv_p; // saved position

		Mode mode;
		Mode persist_mode;

		MarkWin mkw;
		int mk_loc;

		// for scoring
		ccgo::Board::Terri * terri;

		// file selection
		Gtk::FileSelection file_win;
		ccgo::Game * my_game;

		// some more display
		Gtk::Label b_cap;
		Gtk::Label w_cap;

		Glib::RefPtr<Gtk::UIManager> m_uim; // main UI manager
		Glib::RefPtr<Gtk::ActionGroup> m_act; // regular actions
		Glib::RefPtr<Gtk::ActionGroup> m_init; // initialization actions

		// for record list
		ccgo::List * list;
		struct Act
		{
			Glib::RefPtr<Gtk::Action> act;
			Gtk::UIManager::ui_merge_id id;
		};
		std::vector<Act *> rec_act;
		Glib::RefPtr<Gtk::ActionGroup> rec_grp; // record list actions
	};
}
#endif // GO_GTK_GTK_HH
