/* ccgo: go/gtk/gmap.hh
 * 
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_GTK_GMAP_HH
#define GO_GTK_GMAP_HH

#include "go/game0.hh"

#include <gtkmm/window.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/drawingarea.h>

namespace gtk {
	class GMap :
		public Gtk::DrawingArea
	{
	public:
		GMap();
		~GMap();
		void draw_map(ccgo::Node * node);
		void find_node(ccgo::Node * node, unsigned level, int & x, int & y);
		void retrack();

		sigc::signal<void, ccgo::Node *> node_select;
		sigc::signal<void> off_select;
	protected:
		virtual void on_realize();
		virtual bool on_configure_event(GdkEventConfigure * event);
		virtual bool on_expose_event(GdkEventExpose * event);
		virtual bool on_enter_notify_event(GdkEventCrossing * event);
		virtual bool on_leave_notify_event(GdkEventCrossing * event);
		virtual bool on_motion_notify_event(GdkEventMotion * event);

		virtual bool on_button_press_event(GdkEventButton * event);
		virtual bool on_button_release_event(GdkEventButton * event);

		Glib::RefPtr<Gdk::Window> win;
		Glib::RefPtr<Gtk::Style> style;
		int cell_w;
		int cell_h;
	private:
		int lay_nodes(int buoyant);
		void draw_cell(int level, int span);
		void do_track();
		void mark_track();

		int mh;
		int dp;
		struct Node {
			int pa;
			std::vector<int> kd;
			ccgo::Node * n;
			int h;
			enum Type {
				TYPE_NONE = 0,
				TYPE_BLACK = 1, // black move
				TYPE_WHITE = 2, // white move
				TYPE_SETUP,
				TYPE_START,
				TYPE_HANDI
			};
			Type t; // what kind of node
		};
		std::vector<std::vector<Node> > mp;
		std::vector<int> h;
		Gtk::DrawingArea da;

		int cl;
		int cs;
		int tl;
		int ts;
		bool md;
		ccgo::Node * cn; // current node
		ccgo::Position::Turn t;
		ccgo::Walk walk;
	};

	class MapWin :
		public Gtk::Window
	{
	public:
		MapWin();
		void show_map(ccgo::Node * node, unsigned level, int * x = 0, int * y = 0);
		void move_map(int x, int y);
		GMap gm;
		// Glib::RefPtr<Gtk::Adjustment> hadj;
		Gtk::Adjustment * hadj;
		// Glib::RefPtr<Gtk::Adjustment> vadj;
		Gtk::Adjustment * vadj;
	};
}
#endif // GO_GTK_GMAP_HH
