/* ccgo: go/gtk/board.hh
 * 
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_GTK_BOARD_HH
#define GO_GTK_BOARD_HH

#include <go/prop.hh>
#include <gtkmm/menu.h>
#include <gtkmm/label.h>
#include <gtkmm/window.h>
#include <gtkmm/drawingarea.h>
#include <gtkmm/actiongroup.h>

namespace gtk {
	class Board :
		public Gtk::DrawingArea
	{
	public:
		Board();
		~Board();
		void set_board(const ccgo::Board * board); // attach to board
		void update(); // update the whole board
		void update(int loc); // update one loc

		enum TrackMode {
			TRACK_NONE = 0,
			TRACK_BLACK = 1,
			TRACK_WHITE = 2,
			TRACK_STONE,
			TRACK_ALL
		};

		void set_track(TrackMode trackmode);
		TrackMode get_track();
		sigc::signal<void, int> clicked;

		void add_mark(int loc, ccgo::Mark mark);
		void clear_marks();

		void add_label(int loc, const std::string & label);
		void clear_labels();

		void set_block(int loc, bool is_blocked);
		void clear_blocks();

		const Glib::RefPtr<Gtk::ActionGroup> & get_configs();
	protected:
		virtual void on_realize();
		virtual void on_style_changed(const Glib::RefPtr<Gtk::Style> & prev_style);
		virtual bool on_configure_event(GdkEventConfigure * event);
		virtual bool on_expose_event(GdkEventExpose * event);

		virtual bool on_enter_notify_event(GdkEventCrossing * event);
		virtual bool on_leave_notify_event(GdkEventCrossing * event);
		virtual bool on_motion_notify_event(GdkEventMotion * event);

		virtual bool on_button_press_event(GdkEventButton * event);
		virtual bool on_button_release_event(GdkEventButton * event);

		Glib::RefPtr<Gdk::Window> win;
		Glib::RefPtr<Gtk::Style> style;
		int win_w;
		int win_h;
		int cell_w;
		int cell_h;
		int pad_w;
		int pad_h;
	private:
		void do_resize();
		void draw_coordinates();
		int find_loc(int x, int y);
		void do_track();
		void mark_track();

		void toggle_coordinate();
		void toggle_pic_board();
		void toggle_pic_stone();
		void toggle_square_board();

		const ccgo::Board * b;
		int lc; // mouse location

		TrackMode tm;
		int tl; // track loc
		bool md; // mark down

		ccgo::Mark * mk;
		std::string * * lb;
		Gtk::Window tp;
		Gtk::Label tt;
		bool * block; // blocked sites 

		// configurations
		bool show_coordinates; // show coordinates?
		bool pic_board;
		bool pic_stone;
		bool square_board;

		bool bg_pixmap_ok;
		Glib::RefPtr<Gdk::Pixmap> board_pixmap;

		bool stone_image_ok;
		Glib::RefPtr<Gdk::Pixbuf> w_stone_image;
		Glib::RefPtr<Gdk::Pixbuf> b_stone_image;

		bool scaled_ok;
		Glib::RefPtr<Gdk::Pixbuf> scaled_w_stone;
		Glib::RefPtr<Gdk::Pixbuf> scaled_b_stone;

		// configuration actions
		Glib::RefPtr<Gtk::ActionGroup> configs;
	};
}

#endif // GO_GTK_BOARD_HH
