/* ccgo: go/walk_base.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_WALK_BASE_HH
#define GO_WALK_BASE_HH
#include <go/node.hh>
namespace go
{
	class WalkBase // tree traverser
	{
		Node * node;
	protected:
		WalkBase();
		virtual ~WalkBase();
	public:
		Node * where() const;
		void move_to(Node * node); // attach the walk to a node

		// for children to override
		virtual void moved_from(Node * old);
		virtual bool is_movable() const; // can this walk be moved out of the node?

		// be notified of changes to the tree
		virtual void note_gone(); // node is unlinked
		virtual void note_stem(); // node become a non-leaf node
		virtual void note_vary(); // node contents change
	};
}
#endif // GO_WALK_BASE_HH
