/* ccgo: go/walk_base.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <go/walk_base.hh>
#include <debug.hh>
using namespace go;
using namespace std;

WalkBase::WalkBase() :
	node(0)
{
}

WalkBase::~WalkBase()
{
	if (node) node->unpark(this);
}

Node * WalkBase::where() const
{
	return node;
}

void WalkBase::move_to(Node * nd)
{
	if (node == nd) return;
	Node * old = node;
	if (node) node->unpark(this);
	node = nd;
	if (node) node->park(this);
	moved_from(old);
}

void WalkBase::moved_from(Node * old)
{
	// do nothing
}

bool WalkBase::is_movable() const
{
	return true;
}

void WalkBase::note_gone()
{
	assert(node);
	move_to(node->up());
}

void WalkBase::note_stem()
{
	// do nothing
}

void WalkBase::note_vary()
{
	// do nothing
}
