/* ccgo: go/walk.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_WALK_HH
#define GO_WALK_HH
#include <go/walk_base.hh>
#include <go/board.hh>
namespace go
{
	class Walk : // traverser with a Position, game state
		protected WalkBase,
		protected Board
	{
	public:
		Walk();
		virtual ~Walk();
		virtual void moved_from(Node * old);

		// node creation
		Node * add_node();
		Node * add_move(Move move);
		Node * add_setup(const Board & board, Turn turn, unsigned capb, unsigned capw, const std::set<Loc> & ko);

		// node deletion
		void delete_node();
	};
}
#endif // GO_WALK_HH
