/* ccgo: go/walk.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <go/walk.hh>
#include <go/game.hh>
#include <debug.hh>
using namespace go;
using namespace std;

Walk::Walk()
{
}

Walk::~Walk()
{
}

void Walk::moved_from(Node * old)
{
	if (! where()) {
		resize(0); // board size is zero for unattached Walk
		return;
	}

	// calculate total change to the board
	Delta d;
	if (old && old->get_game() == where()->get_game()) { // same tree, find common ancestor
		int i = old->get_level() - where()->get_level(); // difference in depth
		Node * m0 = old;
		while (i > 0) {
			i --;
			d -= m0->delta;
			m0 = m0->up();
		}
		Node * m1 = where();
		while (i < 0) {
			i ++;
			d += m1->delta; 
			m1 = m1->up();
		}
		while (m0 != m1) {
			d -= m0->delta;
			d += m1->delta;
			m0 = m0->up();
			m1 = m1->up();
		}
	}
	else { // different tree, jump to it
		Node * m = where();
		assert(m->get_game());
		copy(m->get_game()->get_init());
		while (m->up()) {
			d += m->delta;
			m = m->up();
		}
	}
	(* this) += d;
}

Node * Walk::add_node()
{
	Node * p = where();
	return new Node(p, Delta(), MoveNone, p->get_turn(), p->get_capb(), p->get_capw(), set<Loc>());
}

Node * Walk::add_move(Move move)
{
	assert(where());
	assert(move != MoveNone);

	Turn turn = where()->get_turn();
	Delta delta;
	unsigned capb = where()->get_capb();
	unsigned capw = where()->get_capw();
	set<Loc> ko = where()->get_ko();

	if (move >= 0) { // regular move
		delta = make_delta(move, turn);
		// calculate captures
		int st = int(turn + 1) % 3 - 1;
		int c = delta.bw_num() - st;
		if (c > 0) capb += c;
		else capw += unsigned(- c);
		turn = flip(turn);
		// check simple ko
		if (c == st) { // capture one stone
			set<Loc> n = neighbors(Loc(move));
			bool surrounded = true;
			while (n.size()) {
				if (state(* n.begin()) != turn) {
					surrounded = false;
					break;
				}
				n.erase(n.begin());
			}
			if (surrounded) {
				ko = delta.sites();
				ko.erase(Loc(move));
			}
			else ko.clear();
		}
		else ko.clear();
	}
	else { // move == MovePass
		delta.clear();
		turn = flip(turn);
		ko.clear();
	}
	Node * n = new Node(where(), delta, move, turn, capb, capw, ko);
	return n;
}

Node * Walk::add_setup(const Board & board, Turn turn, unsigned capb, unsigned capw, const set<Loc> & ko)
{
	assert(where());
	Delta delta = board - * this;
	Node * n = new Node(where(), delta, MoveNone, turn, capb, capw, ko);
	return n;
}

void Walk::delete_node()
{
	assert(is_movable());
	Node * n = where();
	n->unlink();
	delete n;
}
