/* ccgo: go/sgf.hh
 *
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_SGF_HH
#define GO_SGF_HH

#include "game0.hh"
#include <iostream>

namespace ccgo {
	Game * load_sgf(std::istream & stream);
	void save_sgf(Game * game, std::ostream & stream);

	// SGF specific properties
	class SgfNode :
		public Prop
	{
	public:
		virtual ~SgfNode();
		static int the_id();
		virtual int get_id();
		virtual Prop * dup() const;

		enum NodeGood {
			NG_NONE = 0,
			NG_BLACK = 1, // GB
			NG_WHITE = 2, // GW
			NG_EVEN,      // DM
			NG_UNCLEAR    // UC
		};
		enum MoveAnno {
			MA_NONE = 0,
			MA_BAD,         // BM
			MA_DOUBT,       // DO
			MA_INTERESTING, // IT
			MA_GOOD         // TE
		};
	private:
		std::string node_name; // N
		NodeGood ng;
		int ng_degree;
		MoveAnno ma;
		int ma_degree;
		double node_value; // V
		int hotspot; // HO

		double time_black; // BL
		int num_black;     // OB
		double time_white; // WL
		int num_white;     // OW
	};

	class SgfGame :
		public Prop
	{
	public:
		virtual ~SgfGame();
		static int the_id();
		virtual int get_id();
		virtual Prop * dup() const;

	private:
		std::string anno_who;  // AN
		std::string copyright; // CP
		std::string dates;     // DT
		std::string place;     // PC
		std::string event;     // EV
		std::string round;     // RO
		std::string info;      // GC
		std::string source;    // SO
		std::string user;      // US

		std::string rule;      // RU
		std::string time;      // TM
		std::string over_time; // OT
		std::string opening;   // ON
		std::string result;    // RE

		std::string rank_black; // BR
		std::string team_black; // BT
		std::string name_black; // PB
		std::string rank_white; // WR
		std::string team_white; // WT
		std::string name_white; // PW
		
	};
}
#endif // GO_SGF_HH
