/* ccgo: go/prop.hh
 *
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_PROP_HH
#define GO_PROP_HH

#include "go0.hh"
#include <vector>
#include <map>
#include <set>
#include <string>

namespace ccgo
{
	class Prop
	{
	public:
		virtual ~Prop() {}
		static int the_id();
		virtual int get_id();
		virtual Prop * dup() const;
	protected:
		class Id // class counter
		{
		public:
			Id();
			int operator()();
		private:
			static int c;
			int v;
		};
	private:
		static Id id;
	};

	class Comment :
		public Prop
	{
	public:
		virtual ~Comment();
		static int the_id();
		virtual int get_id();
		virtual Prop * dup() const;
		
		const std::string & get_comment();
		void set_comment(const std::string & text);
	private:
		std::string c;
		static Id id;
	};

	enum Mark {
		MARK_NONE = 0,
		MARK_CIRCLE,
		MARK_TRIANGLE,
		MARK_SQUARE,
		MARK_CROSS,
		MARK_SELECT,
		MARK_W_TERRITORY,
		MARK_B_TERRITORY
	};

	class Marking :
		public Prop
	{
	public:
		virtual ~Marking();
		static int the_id();
		virtual int get_id();
		virtual Prop * dup() const;
		void clear_marks();
		void add_mark(int loc, Mark mark);
		Mark get_mark(int loc) const;
		const std::map<int, Mark> & get_marks() const;
	private:
		std::map<int, Mark> m;
		static Id id;
	};

	class Labels :
		public Prop
	{
	public:
		virtual ~Labels();
		static int the_id();
		virtual int get_id();
		virtual Prop * dup() const;
		void clear_labels();
		void add_label(int loc, const std::string & label);
		const std::string & get_label(int loc) const;
		const std::map<int, std::string> & get_labels() const;
	private:
		std::map<int, std::string> lb;
		static Id id;
	};
}
#endif // GO_PROP_HH
