/* ccgo: go/prop.cc
 * 
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "prop.hh"
#include <debug.hh>
#include <iostream>
#include <sstream>
using namespace ccgo;
using namespace std;

// members of class Prop
int Prop::the_id()
{
	return id();
}

int Prop::get_id()
{
	return id();
}

Prop * Prop::dup() const
{
	return new Prop;
}

Prop::Id::Id() :
	v(c ++)
{
}

int Prop::Id::operator()()
{
	return v;
}

int Prop::Id::c = 0;
Prop::Id Prop::id;

// members of class Comment
Comment::~Comment()
{
}

int Comment::the_id()
{
	return id();
}

int Comment::get_id()
{
	return id();
}

Prop * Comment::dup() const
{
	Comment * m = new Comment;
	m->c = c;
	return m;
}

const std::string & Comment::get_comment()
{
	return c;
}

void Comment::set_comment(const std::string & text)
{
	c = text;
}

Prop::Id Comment::id;

// members of class Marking
Marking::~Marking()
{
}

int Marking::the_id()
{
	return id();
}

int Marking::get_id()
{
	return id();
}

Prop * Marking::dup() const
{
	Marking * k = new Marking;
	k->m = m;
	return k;
}

void Marking::clear_marks()
{
	m.clear();
}

void Marking::add_mark(int loc, Mark mark)
{
	if (mark == MARK_NONE) {
		std::map<int, Mark>::iterator i = m.find(loc);
		if (i != m.end()) m.erase(i);
	} else m[loc] = mark;
}

Mark Marking::get_mark(int loc) const
{
	std::map<int, Mark>::const_iterator i = m.find(loc);
	if (i != m.end()) return i->second;
	return MARK_NONE;
}

const std::map<int, Mark> & Marking::get_marks() const
{
	return m;
}

Prop::Id Marking::id;

// members of class Labels
Labels::~Labels()
{
}

int Labels::the_id()
{
	return id();
}

int Labels::get_id()
{
	return id();
}

Prop * Labels::dup() const
{
	Labels * k = new Labels;
	k->lb = lb;
	return k;
}

void Labels::clear_labels()
{
	lb.clear();
}

void Labels::add_label(int loc, const std::string & label)
{
	if (label == "") {
		std::map<int, std::string>::iterator i = lb.find(loc);
		if (i != lb.end()) lb.erase(i);
	} else lb[loc] = label;
}

const std::string & Labels::get_label(int loc) const
{
	static const std::string n("");
	std::map<int, std::string>::const_iterator i = lb.find(loc);
	if (i != lb.end()) return i->second;
	return n;
}

const std::map<int, std::string> & Labels::get_labels() const
{
	return lb;
}

Prop::Id Labels::id;

