/* ccgo: go/path_walk.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_PATH_WALK_HH
#define GO_PATH_WALK_HH
#include <go/walk.hh>
#include <go/path.hh>
namespace go
{
	class PathWalk : // a Walk that keeps Path
		public Walk
	{
		class PathProxy : // Hack! Can be implemented better with a callback library.
			public Path
		{
			PathWalk * path_walk;
			void new_path();
		public:
			PathProxy(PathWalk * pw);
		};
		PathProxy path;
	protected:
		// allowing descendant override
		virtual void new_path();
	public:
		PathWalk();
		virtual ~PathWalk();
		virtual void moved_from(Node * old);
		Node * get_path();
		Node * get_path(unsigned level);
		unsigned get_depth() const;
	};
}
#endif // GO_PATH_WALK_HH
