/* ccgo: go/path_walk.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <go/path_walk.hh>
#include <debug.hh>
#include <iostream>
#include <sstream>
using namespace go;
using namespace std;

void PathWalk::PathProxy::new_path()
{
	path_walk->new_path();
}

PathWalk::PathProxy::PathProxy(PathWalk * pw) :
	path_walk(pw)
{
}

void PathWalk::new_path()
{
}

PathWalk::PathWalk() :
	path(this)
{
}

PathWalk::~PathWalk()
{
}

void PathWalk::moved_from(Node * old)
{
	Walk::moved_from(old);
	path.route(Walk::where());
}

Node * PathWalk::get_path()
{
	unsigned l = where()->get_level();
	if (l < path.get_depth()) return path.get_path(l);
	return 0;
}

Node * PathWalk::get_path(unsigned level)
{
	return path.get_path(level);
}

unsigned PathWalk::get_depth() const
{
	return path.get_depth();
}
