/* ccgo: go/game.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_PATH_HH
#define GO_PATH_HH
#include <go/walk_base.hh>
namespace go
{
	class Path : // keeper of a route to a leaf
		private WalkBase
	{
		std::vector<Node *> path;
		// overriding functions
		void note_gone();
		void note_stem();
	protected:
		// for descendant override
		virtual void new_path();
	public:
		void route(Node * node); // changing the path to the new node
		Node * get_path(unsigned level);
		unsigned get_depth() const;
	};
}
#endif // GO_PATH_HH
