/* ccgo: go/game.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <go/path.hh>
#include <debug.hh>
#include <iostream>
#include <sstream>
using namespace go;
using namespace std;

void Path::note_gone()
{
	assert(where());
	Node * m = where()->up();
	path.pop_back();

	if (m) while (m->down().size()) {
		m = m->down()[0];
		path.push_back(m);
	}
	else path.clear();

	move_to(m);
	new_path();
}

void Path::note_stem()
{
	Node * m = where();
	while (m->down().size()) {
		m = m->down()[0];
		path.push_back(m);
	}
	move_to(m);
	new_path();
}

void Path::new_path()
{
}

void Path::route(Node * n)
{
	if (n == where()) return;
	if (! n) {
		move_to(0);
		path.clear();
		return;
	}

	unsigned l = n->get_level();
	// check if new node is on the path
	if (where() && path.size() >= l && n == (l ? path[l - 1] : (Node *) where()->get_game())) return;

	Node * m = n;
	path.resize(l, 0);

	while (l && path[l - 1] != m) {
		l --;
		path[l] = m;
		m = m->up();
	}

	m = n;
	while (m->down().size()) {
		m = m->down()[0];
		path.push_back(m);
	}
	move_to(m);
	new_path();
}

Node * Path::get_path(unsigned level)
{
	assert(level < path.size());
	return path[level];
}

unsigned Path::get_depth() const
{
	return path.size();
}
