/* ccgo: go/list.hh
 * 
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

// Game list maintainer
#ifndef GO_LIST_HH
#define GO_LIST_HH

#include <go/game0.hh>

namespace ccgo
{
	class List
	{
	public:
		List();
		~List();
		Game * new_game();
		Game * load_game(std::string filename);
		unsigned size();
		Game * get_game(unsigned index);
		Node * get_node(unsigned index);
		std::string get_name(unsigned index);

		void set_node(Node * node);
	private:
		struct G {
			Game * game;
			Node * node; // default node
			std::string file;
		};
		std::vector<G> glist;
	};
}
#endif // GO_LIST_HH
