/* ccgo: go/list.cc
 * 
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "list.hh"
#include "sgf0.hh"
#include <debug.hh>
#include <fstream>
extern "C" {
#include <unistd.h>
}

using namespace ccgo;
using namespace std;

List::List()
{
}

List::~List()
{
	while (glist.size()) {
		G g = glist.back();
		if (g.game) delete g.game;
		glist.pop_back();
	}
}

Game * List::new_game()
{
	G g;
	g.game = new Game;
	g.node = g.game;
	glist.push_back(g);
	return g.game;
}

Game * List::load_game(string fn)
{
	char buf[100];
	if (getcwd(buf, 100)) { // remove cwd from path
		string cwd(buf);
		unsigned l = cwd.size();
		if (fn.size() > l && (fn[l] == '/' || fn[l] == '\\') && cwd == fn.substr(0, l)) {
			fn = fn.substr(l + 1);
		}
	}

	for (vector<G>::iterator i = glist.begin(); i != glist.end(); i ++) if (fn == i->file) { // don't double load
		msg(DBG_WARNING) << "file " << fn << " is already loaded!\n";
		return i->game;
	}

	msg(DBG_INFO) << "loading sgf file: " << fn << '\n';
	G g;
	ifstream f(fn.c_str());
	g.game = load_sgf(f);
	if (! g.game) {
		msg(DBG_ERROR) << "failed to load " << fn << '\n';
		return 0;
	}
	g.node = g.game;
	g.file = fn;
	glist.push_back(g);
	return g.game;
}

unsigned List::size()
{
	return glist.size();
}

Game * List::get_game(unsigned index)
{
	return glist[index].game;
}

namespace {
	bool check_node(Node * tree, Node * node) // check if node exists in tree
	{
		if (node == tree) return true;
		for (unsigned i = 0; i < tree->down_num(); i ++) if (check_node(tree->down(i), node)) return true;
		return false;
	}
};

Node * List::get_node(unsigned index)
{
	G g = glist[index];

	// check if the node is still in the game
	if (check_node(g.game, g.node)) return g.node;
	else return g.game;
}

string List::get_name(unsigned index)
{
	return glist[index].file;
}

void List::set_node(Node * node)
{
	Game * g = node->get_game();
	for (vector<G>::iterator i = glist.begin(); i != glist.end(); i ++) if (g == i->game) i->node = node;
}
