/* ccgo: go/go.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_GO_HH
#define GO_GO_HH
#include <vector>
#include <map>
#include <set>
#include <string>
namespace go
{
	// constants
	typedef int Move;
	typedef unsigned Loc;
	typedef unsigned char State;
	typedef unsigned char Turn;

	const int MovePass = - 1;
	const int MoveNone = - 2;
	const unsigned char Empty = 0;
	const unsigned char Black = 1;
	const unsigned char White = 2;

	inline Turn flip(Turn turn)
	{
		return 3 - turn;
	}

	// for game marking
	enum Mark {
		MARK_NONE = 0,
		MARK_CIRCLE,
		MARK_TRIANGLE,
		MARK_SQUARE,
		MARK_CROSS,
		MARK_SELECT,
		MARK_W_TERRITORY,
		MARK_B_TERRITORY,
		MARK_NUMBER // number of possible markings
	};
}
#endif // GO_GO_HH
