/* ccgo: go/game.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_GAME_HH
#define GO_GAME_HH
#include <go/node.hh>
#include <go/board.hh>
namespace go
{
	class Game :
		public Node
	{
		Board init;
		double komi;
	public:
		Game(const Board & bd, Move mv, Turn tn, unsigned cb, unsigned cw, const std::set<Loc> & k);
		Game();
		~Game();
		void set_komi(double k);

		const Board & get_init() const;
		double get_komi() const;
	};
}
#endif // GO_GAME_HH
