/* ccgo: go/game.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <go/game.hh>
#include <debug.hh>
#include <iostream>
#include <sstream>
using namespace go;
using namespace std;

Game::Game(const Board & bd, Move mv, Turn tn, unsigned cb, unsigned cw, const std::set<Loc> & k) :
	Node(0, Delta(), mv, tn, cb, cw, k),
	init(bd),
	komi(0)
{
	game = this;
	init.copy(bd);
}

Game::Game() :
	Node(0, Delta(), MoveNone, Black, 0, 0, set<Loc>()),
	init(19),
	komi(0)
{
	game = this;
}

Game::~Game()
{
}

void Game::set_komi(double k)
{
	komi = k;
}

const Board & Game::get_init() const
{
	return init;
}

double Game::get_komi() const
{
	return komi;
}
