/* ccgo: go/delta.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef GO_DELTA_HH
#define GO_DELTA_HH
#include <go/go.hh>
#include <vector>
#include <map>
#include <set>
#include <string>
namespace go
{
	class Delta // changes to the Board
	{
	private:
		std::map<Loc, unsigned char> dlist; // change list
		friend class Board;
	public:
		Delta();
		Delta(const Delta & delta);
		void clear();

		int bw_num() const; // change in (# of + 1) - (# of - 1)
		void operator += (const Delta & delta);
		void operator -= (const Delta & delta);
		std::set<Loc> sites() const;
	};
}
#endif // GO_DELTA_HH
