/* ccgo: go/delta.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <go/delta.hh>
#include <debug.hh>
#include <iostream>
#include <sstream>
#include <set>
using namespace go;
using namespace std;

Delta::Delta()
{
}

Delta::Delta(const Delta & delta)
{
	dlist = delta.dlist;
}

void Delta::clear()
{
	dlist.clear();
}

int Delta::bw_num() const
{
	int d = 0;
	for (map<Loc, unsigned char>::const_iterator i = dlist.begin(); i != dlist.end(); i ++) {
		d += (int(i->second + 1) % 3 - 1);
	}
	return d;
}

void Delta::operator += (const Delta & delta)
{
	for (map<Loc, unsigned char>::const_iterator i = delta.dlist.begin(); i != delta.dlist.end(); i ++) {
		map<Loc, unsigned char>::iterator j = dlist.find(i->first);
		if (j == dlist.end()) dlist[i->first] = i->second;
		else {
			j->second = (j->second + i->second) % 3;
			if (j->second == 0) dlist.erase(j);
		}
	}
}

void Delta::operator -= (const Delta & delta)
{
	for (map<Loc, unsigned char>::const_iterator i = delta.dlist.begin(); i != delta.dlist.end(); i ++) {
		map<Loc, unsigned char>::iterator j = dlist.find(i->first);
		if (j == dlist.end()) dlist[i->first] = 3 - i->second;
		else {
			j->second = (j->second + 3 - i->second) % 3;
			if (j->second == 0) dlist.erase(j);
		}
	}
}

set<Loc> Delta::sites() const
{
	set<Loc> s;
	for (map<Loc, unsigned char>::const_iterator i = dlist.begin(); i != dlist.end(); i ++) s.insert(i->first);
	return s;
}
