/* ccgo: go.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GO_HH
#define GO_HH
#include <string>
namespace go
{
	enum Turn {
		TURN_BLACK,
		TURN_WHITE
	};

	enum State {
		STATE_EMPTY = 0,
		STATE_WHITE,
		STATE_BLACK
	};

	enum Terri {
		TERRI_NEUTRAL = 0,
		TERRI_BLACK,
		TERRI_WHITE
	};

	Turn flip(Turn);

	enum Mark {
		MARK_NONE,
		MARK_CIRCLE,
		MARK_TRIANGLE,
		MARK_SQUARE,
		MARK_CROSS,
		MARK_SELECT,
		MARK_W_TERRITORY,
		MARK_B_TERRITORY
	};

	class Loc
	{
		int x;
		int y;
	public:
		Loc();
		Loc(int, int);
		Loc(const std::string &);
		bool operator==(const Loc &) const;
		bool operator!=(const Loc &) const;
		operator bool() const;
		std::string to_string() const;
		int get_x() const;
		int get_y() const;
		int expand(unsigned board_size) const;
		static Loc distribute(int board_size, int number);
		Loc dir1() const;
		Loc dir2() const;
		Loc dir3() const;
		Loc dir4() const;
		bool in_range(unsigned) const;
		void inc(unsigned);
	};
}

#endif // GO_HH
