/* ccgo: go.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "go.hh"
#include <sstream>
using namespace go;

Turn go::flip(Turn t)
{
	return t == TURN_BLACK ? TURN_WHITE : TURN_BLACK;
}

Loc::Loc()
{
	x = -1;
}

Loc::Loc(int xx, int yy)
{
	x = xx;
	y = yy;
}

Loc::Loc(const std::string & i)
{
	std::istringstream s(i);
	char c;
	s.get(c);
	x = c - 'A';
	if (x > 'I' - 'A') -- x;
	s >> y;
	y --;
}

bool Loc::operator==(const Loc & l) const
{
	if (x < 0) return l.x < 0;
	return x == l.x && y == l.y;
}

bool Loc::operator!=(const Loc & l) const
{
	if (x < 0) return l.x >= 0;
	return x != l.x || y != l.y;
}

Loc::operator bool() const
{
	return x >= 0;
}

std::string Loc::to_string() const
{
	if (x < 0) return std::string("--");
	std::ostringstream s;
	char a = 'A' + x;
	if (a >= 'I') a ++;
	s << a << y + 1;
	return s.str();
}

int Loc::get_x() const
{
	return x;
}

int Loc::get_y() const
{
	return y;
}

int Loc::expand(unsigned z) const
{
	return y * z + x;
}

Loc Loc::distribute(int z, int s)
{
	return Loc(s % z, s / z);
}

Loc Loc::dir1() const
{
	return Loc(x + 1, y);
}

Loc Loc::dir2() const
{
	return Loc(x - 1, y);
}

Loc Loc::dir3() const
{
	return Loc(x, y + 1);
}

Loc Loc::dir4() const
{
	return Loc(x, y - 1);
}

bool Loc::in_range(unsigned z) const
{
	return x >= 0 && x < int(z) && y >= 0 && y < int(z);
}

void Loc::inc(unsigned z)
{
	if (x < 0) {
		x = 0;
		y = 0;
		return;
	}
	x ++;
	if (x < int(z)) return;
	y ++;
	x = 0;
	if (y < int(z)) return;
	x = -1;
}
