/* ccgo: gmp/player.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GMP_PLAYER_HH
#define GMP_PLAYER_HH
#include "device.hh"
#include "../player.hh"
namespace gmp
{
	class Player :
		virtual public Device,
		virtual public go::Player
	{
		go::Turn play_turn;
	protected:
		unsigned answer(Query);
		bool move_in(unsigned);
		bool undo_in(unsigned);
	public:
		virtual ~Player();
		void set_arena(go::Arena *);
		void enable_player();
		void disable_player();
		void notify_setup(const go::Board & board);
		void notify_handicap(unsigned n);
		void notify_put(const go::Loc &);
		void notify_pass();
		void notify_undo();
	};
}
#endif // GMP_PLAYER_HH
