/* ccgo: gmp/gmp.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GMP_HH
#define GMP_HH
namespace gmp
{
	extern const unsigned BufferSize;

	enum Cmd {
		CMD_OK = 0,
		CMD_DENY = 1,
		CMD_NEWGAME = 2,
		CMD_QUERY = 3,
		CMD_ANSWER = 4,
		CMD_MOVE = 5,
		CMD_UNDO = 6,
		CMD_EXTENDED = 7
	};

	enum Query {
		QUERY_GAME = 0,
		QUERY_BUFFER = 1,
		QUERY_VERSION = 2,
		QUERY_STONES = 3,
		QUERY_BLACK_TIME = 4,
		QUERY_WHITE_TIME = 5,
		QUERY_CHARSET = 6,
		QUERY_RULE = 7,
		QUERY_HANDICAP = 8,
		QUERY_BOARD_SIZE = 9,
		QUERY_TIME_LIMIT = 10,
		QUERY_COLOR = 11,
		QUERY_WHO = 12
	};

	class Packet {
		unsigned serial;
		unsigned peer;
		Cmd cmd;
		unsigned value;
		unsigned char * ext;
	public:
		Packet();
		Packet(unsigned, unsigned, Cmd, unsigned);
		~Packet();
		void set_serial(unsigned);
		unsigned get_serial() const;
		void set_peer(unsigned);
		unsigned get_peer() const;
		Cmd get_cmd() const;
		unsigned get_value() const;
		void set_ext(unsigned char *);
		const unsigned char * get_ext() const;
		bool operator == (const Packet &) const;
		const Packet & operator = (const Packet &);
	};
}
#endif // GMP_HH
