/* ccgo: gmp/gmp.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "gmp.hh"

using namespace gmp;

const unsigned gmp::BufferSize = 16;

Packet::Packet()
{
	serial = 0;
	peer = 0;
	cmd = CMD_OK;
	value = 1023;
	ext = 0;
}

Packet::Packet(unsigned s, unsigned p, Cmd c, unsigned v)
{
	serial = s;
	peer = p;
	cmd = c;
	value = v;
	ext = 0;
}

Packet::~Packet()
{
	if (ext) delete[] ext;
}

void Packet::set_serial(unsigned s)
{
	serial =s;
}

unsigned Packet::get_serial() const
{
	return serial;
}

void Packet::set_peer(unsigned s)
{
	peer = s;
}

unsigned Packet::get_peer() const
{
	return peer;
}

Cmd Packet::get_cmd() const
{
	return cmd;
}

unsigned Packet::get_value() const
{
	return value;
}

void Packet::set_ext(unsigned char * c)
{
	if (ext) delete[] ext;
	ext = 0;
	if (value < 2) return;
	ext = new unsigned char[value];
	for (unsigned i = 0; i < value; i ++) ext[i] = c[i];
}

const unsigned char * Packet::get_ext() const
{
	return ext;
}

bool Packet::operator == (const Packet & p) const
{
	if (serial != p.serial || peer != p.peer || cmd != p.cmd || value != p.value) return false;
	if (cmd == CMD_EXTENDED) for (unsigned i = 0; i < value; i ++) if (ext[i] != p.ext[i]) return false;
	return true;
}

const Packet & Packet::operator = (const Packet & p)
{
	serial = p.serial;
	peer = p.peer;
	cmd = p.cmd;
	value = p.value;
	if (ext) delete[] ext;
	if (cmd == CMD_EXTENDED) {
		ext = new unsigned char[value];
		for (unsigned i = 0; i < value; i ++) ext[i] = p.ext[i];
	}
	return * this;
}
