/* ccgo: gmp/device.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GMP_DEVICE_HH
#define GMP_DEVICE_HH
#include "gmp.hh"
#include <sigc++/object.h>
#include <sigc++/signal.h>
#include <string>
#include <queue>
#include <glibmm.h>
namespace gmp
{
	class Device :
		public sigc::trackable
	{
	private:
		bool device_ok;
		// handles with child process
		int to_child;
		int from_child;
		pid_t child_pid;
		bool read_child(Glib::IOCondition);
		bool child_timeout();
		void process(unsigned char);
		void process_peer();
		void send(const Packet &);
		sigc::connection read_child_connection;
		sigc::connection child_timeout_connection;
		unsigned char * buffer;
		unsigned buffer_top;
		// packet handling
		std::vector<Packet> to_send;
		Packet sending;
		Packet last_mine;
		bool waiting_ok;
		unsigned waiting_time;
		bool explicit_ok;
		bool conflict;
		Packet last_peer;
		void queue_packet(const Packet &);
		unsigned extension;
	protected:
		virtual unsigned answer(Query);
		void denied();
		void respond(unsigned);
		virtual bool move_in(unsigned);
		virtual bool undo_in(unsigned);
		void newgame();
		bool process_ext();
		std::queue<Packet> cmd_queue;
		void process_queue();
		void queue_command(Cmd, unsigned = 0, unsigned char * = 0);
	public:
		Device();
		virtual ~Device();
		bool fork_child(const std::string &);
		operator bool() const;
		sigc::signal<void> child_exit;
	};
}
#endif // GMP_DEVICE_HH
