/* ccgo: game_walk.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "game_walk.hh"
#include "root_proper.hh"
#include "modifi_proper.hh"
#include "proper_node.hh"
#include "score_proper.hh"

using namespace go;

GameWalk::GameWalk(Node * n) :
	Walk(n),
	Game(),
	started(false)
{
}

void GameWalk::start()
{
	if (started) return;
	while (num) Walk::up(); // walk to root of the tree
	ProperNode * pn = dynamic_cast<ProperNode *>(pos);
	if (! pn) return; // error
	const RootProper * rp = dynamic_cast<const RootProper *>(pn->get_proper());
	if (! rp) return;
	set_board_size(rp->get_size());
	set_komi(rp->get_komi());
	set_handicap(rp->get_handicap());
	set_name(rp->get_game_name());
	if (rp->get_init()) { // initial board setup, assume to be handicaps
		set_board(rp->get_init());
		set_turn(TURN_WHITE);
	} else {
		set_turn(TURN_BLACK);
	}
	started = true;
}

GameWalk::~GameWalk()
{
	// std::cerr << "deleting GameWalk" << std::endl;
}

bool GameWalk::up()
{
	if (! started) return false;
	if (num == 0) return false;
	ProperNode * pn = dynamic_cast<ProperNode *>(pos);
	if (! Walk::up()) return false;
	if (pn == NULL) return true;
	// it's a ProperNode, check if it's a ModifiProper
	const ModifiProper * ap = dynamic_cast<const ModifiProper *>(pn->get_proper());
	// if it is, undo the Modifi
	if (ap != NULL && ap->get_modifi() != NULL) ap->get_modifi()->undo(* this);
	return true;
}

bool GameWalk::down(unsigned i)
{
	if (! started) return false;
	if (! Walk::down(i)) return false;
	ProperNode * pn = dynamic_cast<ProperNode *>(pos);
	if (pn == NULL) return true;
	if (pn->get_proper() == NULL) return true; // cook_node(pos);
	const ModifiProper * ap = dynamic_cast<const ModifiProper *>(pn->get_proper());
	if (ap != NULL && ap->get_modifi() != NULL) ap->get_modifi()->apply(* this);
	return true;
}

const std::string & GameWalk::get_comment() const
{
	static const std::string s("");
	ProperNode * pn = dynamic_cast<ProperNode *>(pos);
	if (pn == NULL) return s;
	if (pn->get_proper() == NULL) return s;
	return pn->get_proper()->get_comment();
}

bool GameWalk::add_move(Move * m)
{
	if (! m->check(* this)) {
		delete m;
		return false;
	}
	ModifiProper * ap = new ModifiProper;
	ap->set_modifi(m);
	ProperNode * pn = new ProperNode;
	pn->set_proper(* this, ap);
	get_pos()->set_next(pn);
	return true;
}

bool GameWalk::add_score(Terri * t)
{
	ScoreProper * p = new ScoreProper;
	p->set_terri(* this, t);
	ProperNode * pn = new ProperNode;
	pn->set_proper(* this, p);
	get_pos()->set_next(pn);
	return true;
}
