/* ccgo: game_setup.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GAME_SETUP_HH
#define GAME_SETUP_HH
#include <gtkmm/dialog.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/entry.h>
#include <gtkmm/optionmenu.h>

namespace go {
	class PlayerSelect :
		public Gtk::OptionMenu
	{
		Gtk::Entry path;
	public:
		PlayerSelect();
		std::string get_path();
		void set_path(const std::string &);
	};

	class GameSetup :
		public Gtk::Dialog
	{
		void on_response(int);
		Gtk::Adjustment * board_size;
		Gtk::Adjustment * handicap;
		Gtk::Adjustment * komi;
		PlayerSelect white;
		PlayerSelect black;
		void board_size_change();
		void handicap_change();
	public:
		GameSetup();
	};
}
#endif // GAME_SETUP_HH
