/* ccgo: game_setup.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "config.hh"
#include "gettext.h"
#include "game_setup.hh"
#include "part_win.hh"
#include "gmp/player.hh"
#include "settings.hh"
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/stock.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/menu.h>

#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace go;

PlayerSelect::PlayerSelect()
{
	Gtk::Menu * m = Gtk::manage(new Gtk::Menu);
	m->append(* Gtk::manage(new Gtk::MenuItem(_("Human"))));
	Gtk::HBox * hb = Gtk::manage(new Gtk::HBox);
	Gtk::Label * lb = Gtk::manage(new Gtk::Label(_("GnuGo") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(path);
	m->append(* Gtk::manage(new Gtk::MenuItem(* hb)));
	set_menu(* m);
}

std::string PlayerSelect::get_path()
{
	return path.get_text();
}

void PlayerSelect::set_path(const std::string & p)
{
	path.set_text(p);
}
///////////////////////////////////////////////////////////////////////////////////////////
Player * create_player_from_select(PlayerSelect & ps)
{
	if (! ps.get_history()) return 0;
	gmp::Player * p = new gmp::Player;
	p->fork_child(ps.get_path());
	if (! (* p)) {
		delete p;
		p = 0;
	}
	return p;
}
////////////////////////////////////////////////////////////////////////////////////////////
void GameSetup::on_response(int r)
{
	switch (r) {
	case 0: // cancel
		hide();
		break;
	case 1: // launch game
		hide();
		settings.set_string("white-program-path", white.get_path());
		settings.set_string("black-program-path", black.get_path());
		new PartWin(unsigned(board_size->get_value()), komi->get_value(), unsigned(handicap->get_value()), create_player_from_select(white), create_player_from_select(black));
		break;
	default:
		break;
	}
}

void GameSetup::board_size_change()
{
	int z = int(board_size->get_value());
	if (z != 19) {
		handicap->set_value(1);
	}
}

void GameSetup::handicap_change()
{
	int h = int(handicap->get_value());
	if (h != 1) {
		board_size->set_value(19);
	}
}


GameSetup::GameSetup() :
	Dialog(_("Game setup")),
	board_size(Gtk::manage(new Gtk::Adjustment(19, 5, 25))),
	handicap(Gtk::manage(new Gtk::Adjustment(1, 1, 9))),
	komi(Gtk::manage(new Gtk::Adjustment(5.5, -1000, 1000, 0.5)))
{
	Gtk::Label * lb = Gtk::manage(new Gtk::Label(_("Game setup")));
	get_vbox()->pack_start(* lb, Gtk::PACK_SHRINK);

	Gtk::HBox * hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Board size") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	Gtk::SpinButton * sb = Gtk::manage(new Gtk::SpinButton(* board_size));
	sb->set_snap_to_ticks();
	hb->pack_start(* sb, Gtk::PACK_SHRINK);

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Handicap") + ": (1 = " + _("even game") + ") "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	sb = Gtk::manage(new Gtk::SpinButton(* handicap));
	sb->set_snap_to_ticks();
	hb->pack_start(* sb, Gtk::PACK_SHRINK);

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Komi") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	sb = Gtk::manage(new Gtk::SpinButton(* komi));
	sb->set_digits(1);
	sb->set_snap_to_ticks();
	hb->pack_start(* sb, Gtk::PACK_SHRINK);

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("White") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(white);
	std::string n;
	n = settings.get_string("white-program-path");
	if (! n.length()) n = "/usr/games/gnugo";
	white.set_path(n);

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	lb = Gtk::manage(new Gtk::Label(_("Black") + ": "));
	hb->pack_start(* lb, Gtk::PACK_SHRINK);
	hb->pack_start(black);
	n = settings.get_string("black-program-path");
	if (! n.length()) n = "/usr/games/gnugo";
	black.set_path(n);

	add_button(Gtk::Stock::CANCEL, 0);
	add_button(Gtk::Stock::OK, 1);

	// handicap cap only for 19x19 games
	board_size->signal_value_changed().connect(mem_fun(* this, & GameSetup::board_size_change));
	handicap->signal_value_changed().connect(mem_fun(* this, & GameSetup::handicap_change));
}
