/* ccgo: game.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef GAME_HH
#define GAME_HH
#include "board.hh"
#include "rule.hh"
#include <vector>
namespace go
{
	class Game
	{
	private:
		class QiData
		{
			unsigned size;
		public:
			State state;
			bool * mark;
			QiData(unsigned);
			~QiData();
			void clear();
			bool & operator[] (const Loc &);
		};
		int qi_group(const Loc &, std::vector<Loc> &, QiData &) const;
		Rule rule;
		class ScoreData
		{
		private:
			unsigned size;
			Terri * terri;
			bool * mark;
		public:
			ScoreData(unsigned, Terri *);
			~ScoreData();
			Terri & t(const Loc &);
			bool & m(const Loc &);
			void m_clear();
		};
		void terri_group(const Loc &, std::vector<Loc> &, bool &, bool &, ScoreData &) const;
		void hang_group(const Loc &, State, std::vector<Loc> &, ScoreData &) const;
	protected:
		Board * board;
		double komi;
		unsigned handicap;
		std::string name;
		unsigned move_num;
		Turn turn;
		Loc ko;
		Loc last_move;
		unsigned cap_w;
		unsigned cap_b;
	public:
		Game();
		Game(const Game &);
		virtual ~Game();
		// virtual Game & operator= (const Game &);

		// pre game properties
		const Rule & get_rule() const;
		virtual void set_rule(const Rule &);
		double get_komi() const;
		virtual void set_komi(double);
		unsigned get_handicap() const;
		virtual void set_handicap(unsigned);
		unsigned get_board_size() const;
		virtual void set_board_size(unsigned);
		const std::string & get_name() const;
		virtual void set_name(const std::string &);
		virtual void set_board(const Board *);

		// game play properties
		unsigned get_move_num() const;
		virtual void set_move_num(unsigned);
		Turn get_turn() const;
		virtual void set_turn(Turn);
		const Loc & get_ko() const;
		virtual void set_ko(const Loc &);
		const Loc & get_last_move() const;
		virtual void set_last_move(const Loc &);
		State get_site(const Loc &) const;
		virtual void set_site(const Loc &, State);
		unsigned get_cap_w() const;
		virtual void set_cap_w(unsigned);
		unsigned get_cap_b() const;
		virtual void set_cap_b(unsigned);

		// status checking
		void get_group(const Loc &, std::vector<Loc> &) const;
		void get_kill(const Loc &, std::vector<Loc> &) const;
		bool check_space(const Loc &) const;
		bool check_eye(const Loc &) const;
		int check_fill(const Loc &, std::vector<Loc> &) const;
		void score_terri(Terri *) const;
	};
}
#endif // GAME_HH
