/* ccgo: debug.hh
 *
 * Copyright (C) 2008 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef DEBUG_HH
#define DEBUG_HH

#include "config.hh"
#include <iostream>
#include <cassert>

#ifdef DEBUG
#define debug(x) (void)({x})
#define debug_enabled() (true)
#else
#define debug(x) (void) 0
#define debug_enabled() (false)
#endif

extern int debug_level;

enum DebugLevels {
	DBG_ERROR = 1,
	DBG_WARNING = 2,
	DBG_INFO = 3,
	DBG_DEBUG = 4
};

// void debug_message(int level, std::string message);
std::ostream & debug_stream(int level);
class DummyOut {};
extern DummyOut dummy_out;

template<class TT>
DummyOut & operator<< (DummyOut & o, TT)
{
	return o;
}


#ifdef DEBUG
#define msg(x) debug_stream(x)
#else
#define msg(x) dummy_out
#endif

#endif // DEBUG_HH
