/* ccgo: board.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef BOARD_HH
#define BOARD_HH
#include "go.hh"
namespace go
{
	class Board
	{
	public:
		static State other(State);
		static State stone(Turn);
	protected:
		int size;
		State * board;
	public:
		Board(unsigned = 19);
		virtual ~Board();
		int get_size() const;
		virtual Board * dup() const;
		virtual void copy(const Board &);
		static State turn_state(Turn);
		State get_site(const Loc &) const;
		void set_site(const Loc &, State);
		State & operator[] (const Loc &);
	};
}
#endif // BOARD_HH
