/* ccgo: board.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "board.hh"

using namespace go;

State Board::other(State s)
{
	if (s == STATE_WHITE) return STATE_BLACK;
	if (s == STATE_BLACK) return STATE_WHITE;
	return STATE_EMPTY;
}

State Board::stone(Turn t)
{
	if (t == TURN_BLACK) return STATE_BLACK;
	return STATE_WHITE;
}

Board::Board(unsigned s)
{
	size = s;
	board = new State[size * size];
	for (int i = 0; i < size * size; i ++) board[i] = STATE_EMPTY;
}

Board::~Board()
{
	if (board != NULL) delete board;
}

int Board::get_size() const
{
	return size;
}

Board * Board::dup() const
{
	Board * n = new Board(size);
	for (int i = 0; i < size * size; i ++) n->board[i] = board[i];
	return n;
}

void Board::copy(const Board & b)
{
	if (b.size != size) return;
	for (int i = 0; i < size * size; i ++) board[i] = b.board[i];
}

State Board::turn_state(Turn t)
{
	if (t == TURN_BLACK) return STATE_BLACK;
	else return STATE_WHITE;
}

State Board::get_site(const Loc & l) const
{
	return board[l.expand(size)];
}

void Board::set_site(const Loc & l, State s)
{
	board[l.expand(size)] = s;
}

State & Board::operator[] (const Loc & l)
{
	return board[l.expand(size)];
}
