/* ccgo: arena.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef ARENA_HH
#define ARENA_HH
#include "go.hh"
#include "game.hh"
namespace go
{
	class Player;

	class Arena
	{
		Player * black;
		Player * white;
		bool in_action;
		bool in_scoring;
		unsigned pass_count;
	public:
		Arena();
		virtual ~Arena();
		void set_player(Turn, Player *);
		bool check_player(Turn, Player *);
		virtual const Game * get_game() const;
		virtual void start_action();
		virtual void stop_action();
		virtual void enter_score();
		virtual void done_score();
		bool request_handicap(Player *, unsigned);
		bool request_put(Player *, const Loc &);
		bool request_pass(Player *);
		bool request_undo(Player *);
		bool request_terri(Player *, const Loc &);
		bool request_reset(Player *);
		bool request_done(Player *);
		virtual bool action_handicap(unsigned);
		virtual bool action_put(const Loc &);
		virtual bool action_pass();
		virtual bool action_undo();
		virtual bool action_terri(const Loc &);
		virtual bool action_reset();
		virtual bool action_done();

		virtual void ask_terri(Terri *);
	};
}
#include "player.hh"
#endif // ARENA_HH
