#pragma once
#include "stdint.hpp"

/***************************************************************************
	Sprite Palettes.
	
	- Additional CannonBall Sprite Palettes Start At Entry 256.
	- 32 Bytes Per Entry
	- Originally stored at 0x14ed8
	
	Each 16-bit entry in color RAM has the following layout:

	D15 : Shade hi/lo
	D14 : Blue bit 0
	D13 : Green bit 0
	D12 : Red bit 0
	D11 : Blue bit 4
	D10 : Blue bit 3
	D9 : Blue bit 2
	D8 : Blue bit 1
	D7 : Green bit 4
	D6 : Green bit 3
	D5 : Green bit 2
	D4 : Green bit 1
	D3 : Red bit 4
	D2 : Red bit 3
	D1 : Red bit 2
	D0 : Red bit 1
***************************************************************************/

// Exported as Big Endian, Double Words, 8 Columns
const static uint32_t PALETTE_EXPANSION[] = 
{
	0x000009ff, 0x08fd07eb, 0x05c804b5, 0x02920170, 0x00500030, 0x0000056a, 0x03480126, 0x00140000, 
	0x00000008, 0x033a055c, 0x066d088d, 0x0aad0ddd, 0x098b0777, 0x0aaa0008, 0x00000888, 0x04440000, 
	0x00000008, 0x033a055c, 0x066d088d, 0x0aad0ddd, 0x09ab089a, 0x007d0008, 0x00000888, 0x06660000, // Palette 2: Red Ferrari. No Brake Lamp / Tyre Pattern A 
	0x00000008, 0x033a055c, 0x066d088d, 0x0aad0ddd, 0x09ab089a, 0x007d0008, 0x00000666, 0x08880000, // Palette 3: Red Ferrari. No Brake Lamp / Tyre Pattern B
	0x00000008, 0x033a055c, 0x066d088d, 0x0aad0ddd, 0x09ab089a, 0x007d000f, 0x00000888, 0x06660000, // Palette 4: Red Ferrari. Brake Lamp On / Tyre Pattern A
	0x00000008, 0x033a055c, 0x066d088d, 0x0aad0ddd, 0x09ab089a, 0x007d000f, 0x00000666, 0x08880000, // Palette 5: Red Ferrari. Brake Lamp On / Tyre Pattern B
	0x00000000, 0x0fff0efd, 0x0efb0df6, 0x0ce80cfd, 0x0cda0dc9, 0x0db80da9, 0x0bd00ac0, 0x0be00000, 
	0x00007fff, 0x0ded0dec, 0x0cdb0abb, 0x0ffe0eed, 0x0ccc0ced, 0x09990ffd, 0x09980abb, 0x09990000, 
	0x000000be, 0x00ef0bdf, 0x09ad088b, 0x0bac0a0c, 0x090a0708, 0x00000d98, 0x0c680078, 0x0da30000, 
	0x00000069, 0x00bd0bdf, 0x09ad088b, 0x00ef09b7, 0x07960574, 0x00000fff, 0x0cbb0988, 0x0fff0000, 
	0x00000047, 0x00690bde, 0x09be087b, 0x06580d78, 0x0b600700, 0x00000eee, 0x0aaa0777, 0x00000000, // Palette 10: Man in car
	0x00000047, 0x006900ef, 0x09be087b, 0x06580d78, 0x0b600700, 0x00000eee, 0x0aaa0777, 0x00000000, 
	0x00000000, 0x0fff0bdf, 0x0ace0659, 0x09000700, 0x000e000a, 0x00f80fff, 0x006a0ddd, 0x0bbb0000, 
	0x00000000, 0x00dd0d18, 0x09770a99, 0x0c990ddd, 0x0448056b, 0x088800b0, 0x03a50888, 0x00000000, 
	0x00000000, 0x00dd0d18, 0x09770a99, 0x0c990ddd, 0x0448056b, 0x088800b0, 0x03a50000, 0x08880000, 
	0x00000000, 0x0ddd000c, 0x09900bb8, 0x0cc90ddd, 0x09550b78, 0x088a00bd, 0x038c0888, 0x00000000, 
	0x00000000, 0x0ddd000c, 0x09900bb8, 0x0cc90ddd, 0x09550b78, 0x088a00bd, 0x038c0000, 0x08880000, 
	0x00000000, 0x07d70a50, 0x079709b7, 0x0ad90ddd, 0x079909cc, 0x09830daa, 0x0b990888, 0x00000000, 
	0x00000000, 0x07d70a50, 0x079709b7, 0x0ad90ddd, 0x079909cc, 0x09830daa, 0x0b990000, 0x08880000, 
	0x00000000, 0x0ddd00d9, 0x02cc08cc, 0x0add0ddd, 0x0ddd0bab, 0x088a00bd, 0x038c0888, 0x00000000, 
	0x00000000, 0x0ddd00d9, 0x02cc08cc, 0x0add0ddd, 0x0ddd0bab, 0x088a00bd, 0x038c0000, 0x08880000, // Palette 20
	0x00000000, 0x00b100dd, 0x099d0aad, 0x0bbd0ddd, 0x08880bbb, 0x08770daa, 0x0a990888, 0x00000000, 
	0x00000000, 0x00b100dd, 0x099d0aad, 0x0bbd0ddd, 0x08880bbb, 0x08770daa, 0x0a990000, 0x08880000, 
	0x00000444, 0x06950638, 0x076a097d, 0x099d0ddd, 0x0ccb0ba9, 0x009d000b, 0x00000888, 0x00000000, 
	0x00000444, 0x06950638, 0x076a097d, 0x099d0ddd, 0x0ccb0ba9, 0x009d000b, 0x00000000, 0x08880000, 
	0x00000fee, 0x0acb0dab, 0x0a870865, 0x00000644, 0x05330b45, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06660000, 0x00000000, 0x00000000, 
	0x00000ddd, 0x09dd05bd, 0x0c8d00ad, 0x00c00dad, 0x068c0677, 0x0980000d, 0x066a0d9a, 0x0a500000, 
	0x00000000, 0x034b0255, 0x058807aa, 0x08cc0ddd, 0x0ddb0cc9, 0x007d0008, 0x00000888, 0x00000000, 
	0x00000000, 0x034b0255, 0x058807aa, 0x08cc0ddd, 0x0ddb0cc9, 0x007d0008, 0x00000000, 0x08880000, 
	0x00000fff, 0x00ee050b, 0x0ffb0400, 0x09990aac, 0x00bb0079, 0x06be049c, 0x00ff0ff0, 0x00000000,  // Palette 30
	0x00000fff, 0x0f00050b, 0x0ffb0400, 0x09990aac, 0x00bb0079, 0x06be049c, 0x00ff0ff0, 0x00000000, 
	0x00000eff, 0x0bef0bde, 0x0acb0ab9, 0x0bba0cee, 0x09a808be, 0x09af069f, 0x028f049f, 0x018f0000, 
	0x00000fff, 0x0fff000f, 0x000f0b90, 0x000f0ecb, 0x060005b9, 0x09990000, 0x0fff07ba, 0x06000000, 
	0x00000fff, 0x0fff000f, 0x000f0b90, 0x000f0ecb, 0x060005b9, 0x09990000, 0x060007ba, 0x0fff0000, 
	0x00000fff, 0x000f0fff, 0x000f0b90, 0x000f0ecb, 0x060005b9, 0x09990000, 0x0fff07ba, 0x06000000, 
	0x00000fff, 0x000f0fff, 0x000f0b90, 0x000f0ecb, 0x060005b9, 0x09990000, 0x060007ba, 0x0fff0000, 
	0x00000000, 0x00a000ba, 0x09cb09ba, 0x09a807a6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00007fff, 0x0fff0eee, 0x0ddd0ccc, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000eff, 0x0cef0bdf, 0x0ace09bd, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x000f0fff, 0x0fff000f, 0x000f0fff, 0x000f0bcb, 0x0ddd0b77, 0x07000aaa, 0x00000000, // Palette 40
	0x000007ff, 0x07ff0800, 0x07ff07ff, 0x08000800, 0x08000bcb, 0x0ba90b77, 0x07000fff, 0x00000000, 
	0x000007ff, 0x07ff07ff, 0x00600060, 0x07ff0060, 0x00600bcb, 0x0ba90b77, 0x07000fff, 0x00000000, 
	0x0000009a, 0x00500064, 0x008600a6, 0x00d60ddd, 0x7ada0689, 0x08980666, 0x08ab089a, 0x00680000, 
	0x00000036, 0x00340036, 0x00570030, 0x047c026a, 0x00260369, 0x05550336, 0x07670048, 0x00170000, 
	0x00000047, 0x00690000, 0x09be087b, 0x06580d78, 0x0b600700, 0x0000000e, 0x00000bbb, 0x09990000, 
	0x000000be, 0x00ef0bdf, 0x09ad088b, 0x08ac0a0c, 0x00000000, 0x00000000, 0x00000bbb, 0x09990000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000bcb, 0x0ba90b67, 0x07000fff, 0x00000000, 
	0x00000fff, 0x0c800a60, 0x08600dcc, 0x000e0bbb, 0x099907ff, 0x0c8907ff, 0x08600c80, 0x08600000, 
	0x00000fff, 0x0c800a60, 0x0fff0dcc, 0x000e0bbb, 0x09990fff, 0x0c890c80, 0x0c800fff, 0x0c800000, 
	0x00000000, 0x07770889, 0x089a09ab, 0x00000bcd, 0x0cde0fff, 0x00000eff, 0x0cef0ace, 0x079b0000, // Palette 50
	0x00000bcd, 0x08770887, 0x08860764, 0x05530000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x0ccc0000, 0x0bbb00ff, 0x00b00080, 0x00ac0079, 0x0ab90e00, 0x0d000c00, 0x0b000000, 
	0x00000000, 0x0ddd0ccc, 0x0bbb0aaa, 0x09990888, 0x07770fff, 0x00000079, 0x008a009b, 0x00ac0000, 
	0x00000abc, 0x09ac089a, 0x08890478, 0x05790456, 0x049600a0, 0x08970560, 0x009000c0, 0x0ddd0000, 
	0x0000007a, 0x00ad0bdf, 0x0acf09bd, 0x08ac0dcb, 0x0dbb0dab, 0x000e000e, 0x00000bbb, 0x09990000, 
	0x000008bc, 0x059a0579, 0x04670246, 0x03460235, 0x00240355, 0x05880000, 0x00000457, 0x02230000, 
	0x000008ba, 0x06aa0589, 0x03670256, 0x02450244, 0x00340124, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00dd0444, 0x06660999, 0x0bbb0ddd, 0x099a0ab1, 0x008c0009, 0x00000888, 0x00000000, 
	0x00000000, 0x00dd0444, 0x06660999, 0x0bbb0ddd, 0x099a0ab1, 0x008c0009, 0x00000000, 0x08880000, 
	0x00000000, 0x00450078, 0x0cc500aa, 0x00bb00cc, 0x09dd0fff, 0x0aaa0ccc, 0x000b0888, 0x00000000, 
	0x00000000, 0x00450078, 0x0cc500aa, 0x00bb00cc, 0x09dd0fff, 0x0aaa0ccc, 0x000b0888, 0x00000000, 
	0x00000000, 0x00130024, 0x01340146, 0x03560368, 0x08990ccc, 0x00740c00, 0x0c000c00, 0x0c000000, 
	0x00000000, 0x06470748, 0x0bb9092a, 0x0b3c0c8d, 0x0cad0ddd, 0x007806bb, 0x00090888, 0x00000000, 
	0x00000000, 0x06470748, 0x0bb9092a, 0x0b3c0c8d, 0x0cad0ddd, 0x007806bb, 0x00090000, 0x08880000, 
	0x00000000, 0x0aaa0abb, 0x0ccc0ccc, 0x0eee0fff, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x080f050b, 0x0ffb0400, 0x09990aac, 0x00bb0079, 0x06be049c, 0x00ff0ff0, 0x00000000, 
	0x00000047, 0x00450047, 0x00680040, 0x058d037b, 0x0037047a, 0x06660447, 0x08780059, 0x00280000, 
	0x00003036, 0x30343036, 0x30573030, 0x347c326a, 0x30263369, 0x35553336, 0x37673048, 0x30170000, 
	0x00000fff, 0x0eee0ddd, 0x0ff0000f, 0x000c0000, 0x000f000c, 0x00000000, 0x000a000e, 0x00bd0000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000ddd, 0x00000aaa, 0x00000000, 0x00000000, 0x00000000, 
	0x00000cff, 0x0cfc09ef, 0x08c800c0, 0x00b00090, 0x0afe00eb, 0x00ab00c8, 0x009008ca, 0x0fff0000, 
	0x00000aee, 0x0c0e0e0f, 0x08d80fbf, 0x00b000a0, 0x0fdf0f9f, 0x00ab0b0e, 0x009008ba, 0x0fff0000, 
	0x00000abf, 0x09de0ade, 0x07bd00ad, 0x009b008a, 0x0ade00cc, 0x00ab00bd, 0x008a008c, 0x0bff0000, 
	0x00000cff, 0x0cfe00ff, 0x0afd00c0, 0x00b00090, 0x07ff00ef, 0x00ab00f8, 0x00a008da, 0x0fff0000, 
	0x00000333, 0x00460357, 0x04670479, 0x0689069b, 0x0bcc0fff, 0x02a70f00, 0x0f000f00, 0x0f000000, 
	0x00000000, 0x079c04b4, 0x01940070, 0x058a0579, 0x0568098c, 0x06660a9d, 0x0cad0dbd, 0x0ddd0000, 
	0x00000256, 0x0689089b, 0x08ab0abc, 0x09cd00e0, 0x00b700aa, 0x0cb90090, 0x000009ff, 0x0fff0000, 
	0x00000fff, 0x08880c00, 0x0e900eb0, 0x0fc00cdd, 0x0dee0abb, 0x000000ad, 0x0bcc0baf, 0x09000000, 
	0x00000056, 0x04670689, 0x089a0799, 0x089908aa, 0x09ba09aa, 0x0a970000, 0x00000000, 0x00000000, 
	0x00000000, 0x088809aa, 0x0abb0bcc, 0x0cee0dee, 0x0fff000d, 0x0a870cdd, 0x0acd000f, 0x09bb0000, 
	0x00000478, 0x07760788, 0x08aa09ba, 0x0bc90bcb, 0x0ced068e, 0x0f0008cd, 0x08bc07ac, 0x089b0000, 
	0x00000000, 0x05550666, 0x08880bbb, 0x09990ccc, 0x0ddd0000, 0x0fff0000, 0x00000000, 0x00000000, 
	0x00000478, 0x0fff0ade, 0x09cd08bc, 0x07ac079b, 0x068a007e, 0x00f00877, 0x09990e9a, 0x0c880000, 
	0x00000478, 0x0fff0aef, 0x08cf07bf, 0x049f067f, 0x08880999, 0x00f00aaa, 0x0bbb0ccc, 0x0ddd0000, 
	0x00000478, 0x0fff0aef, 0x08cf07bf, 0x049f067f, 0x08880999, 0x00f00aaa, 0x0bbb0ccc, 0x0ddd0000, 
	0x00000000, 0x0fff0efd, 0x0efb0ef6, 0x0de70dfd, 0x0dda0ec9, 0x0eb80ea9, 0x0cc00cd9, 0x0dfb0000, 
	0x00000dee, 0x0dee09aa, 0x0cdd0bcc, 0x09ab0677, 0x0efe0eff, 0x0a900bce, 0x09ac078a, 0x07890000, 
	0x000000ca, 0x089a08a8, 0x07bb0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x0000088a, 0x0aab0889, 0x0aab0000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000665, 0x06650443, 0x06650068, 0x00570036, 0x002308aa, 0x00000665, 0x00000a98, 0x08800000, 
	0x00000000, 0x078a079b, 0x07ac007f, 0x0fff0d87, 0x0a8700ff, 0x0280007c, 0x0ccc0bbb, 0x09990000, 
	0x00000fff, 0x009008af, 0x00000eee, 0x00900fff, 0x0fff0fff, 0x00000090, 0x0fbb0fff, 0x00900000, 
	0x00000fff, 0x009008af, 0x00000eee, 0x00900090, 0x00900fff, 0x00000fff, 0x0fbb0fff, 0x0fff0000, 
	0x00000fff, 0x009008af, 0x00000eee, 0x0fff0090, 0x0fff0090, 0x00000fff, 0x0fbb0fff, 0x00900000, 
	0x00000000, 0x04430355, 0x04660577, 0x07880899, 0x0bbb0044, 0x00000044, 0x00870044, 0x00440000, 
	0x00000000, 0x04430355, 0x04660577, 0x07880899, 0x0bbb0044, 0x000000af, 0x00870044, 0x70af0000, 
	0x00000000, 0x03320244, 0x03550466, 0x06770799, 0x0aaa007a, 0x00000055, 0x0055007a, 0x00aa0000, 
	0x00000000, 0x03320244, 0x03550466, 0x06770799, 0x0aaa007a, 0x0000009e, 0x0055007a, 0x00aa0000, 
	0x0000000d, 0x0fff0ace, 0x09bd089c, 0x0000007b, 0x00480fff, 0x00000edd, 0x0dbb0888, 0x007a0000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee0000f, 0x000d000b, 0x0ade0fff, 0x00000000, 
	0x00000fbe, 0x0fde0eec, 0x0bf60be0, 0x0fce0ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x07770000, 
	0x00000000, 0x0ddd09bd, 0x08ad079d, 0x0bc90aa7, 0x0a9708dd, 0x0000006c, 0x0a8b0759, 0x06060000, 
	0x00000000, 0x0ddd09bd, 0x08ad079d, 0x09a70897, 0x078708ad, 0x0000006c, 0x0a8b0759, 0x06060000, 
	0x00000000, 0x0ddd09bd, 0x08ad079d, 0x0bc90aa7, 0x0a9708ad, 0x0000006c, 0x0a8b0759, 0x06060000, 
	0x00000000, 0x0ddd09bd, 0x08ad079d, 0x09a70897, 0x078708dd, 0x0000006c, 0x0a8b0759, 0x00600000, 
	0x00000000, 0x006809bd, 0x08ad079d, 0x0bd90ba9, 0x007a00cd, 0x000d00ac, 0x088b0a79, 0x06880000, 
	0x00000000, 0x006809bd, 0x08ad079d, 0x0bc90ba9, 0x007a00cd, 0x000d00ac, 0x088b0a79, 0x06480000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x08880aaa, 0x0bbb0ccc, 0x0eee0fff, 0x0ddf0bbf, 0x0000099f, 0x077f055c, 0x022a0000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee0000f, 0x000d000b, 0x0ade0fff, 0x00000000, 
	0x00000000, 0x0ffc0777, 0x08880999, 0x0aaa0bbb, 0x0ccc0ddd, 0x0fff0aaf, 0x089f066e, 0x055c0000, // Palette 111: Red Ferrari. Flip
	0x00000000, 0x036809bd, 0x08ad079c, 0x0bc90bac, 0x038a00cc, 0x000d00ad, 0x0a8b0a79, 0x06480000, 
	0x00000000, 0x06660778, 0x0789089a, 0x00000abc, 0x0bcd0eee, 0x00000dee, 0x0bde09bd, 0x068a0000, 
	0x00000444, 0x05550555, 0x06660777, 0x09990ccc, 0x0ffd0cc9, 0x007d0008, 0x00000aaa, 0x07770000, 
	0x00000444, 0x05550555, 0x06660777, 0x09990ccc, 0x0ffd0cc9, 0x007d0008, 0x00000777, 0x0aaa0000, 
	0x00000666, 0x0448044a, 0x066c188e, 0x1aaf0fff, 0x0ffd0cc9, 0x007d000a, 0x00000aaa, 0x07770000, 
	0x00000666, 0x0448044a, 0x066c188e, 0x1aaf0fff, 0x0ffd0cc9, 0x007d000a, 0x00000777, 0x0aaa0000, 
	0x00000666, 0x08440a44, 0x0c664e88, 0x4faa0fff, 0x0ffd0cc9, 0x007d000a, 0x00000aaa, 0x07770000, 
	0x00000666, 0x08440a44, 0x0c664e88, 0x4faa0fff, 0x0ffd0cc9, 0x007d000a, 0x00000777, 0x0aaa0000, 
	0x00000666, 0x048004a0, 0x06c068e0, 0x6af00fff, 0x0ffd0cc9, 0x007d000a, 0x00000aaa, 0x07770000, 
	0x00000666, 0x048004a0, 0x06c068e0, 0x6af00fff, 0x0ffd0cc9, 0x007d000a, 0x00000777, 0x0aaa0000, 
	0x00000007, 0x00070400, 0x0bcb0ba9, 0x0b770700, 0x0b4000ff, 0x000f07a0, 0x07000fff, 0x00000000, 
	0x0000142f, 0x00070400, 0x0bcb0ba9, 0x0b770700, 0x0b4000ff, 0x000f07a0, 0x07000fff, 0x00000000, 
	0x00000007, 0x142f0400, 0x0bcb0ba9, 0x0b770700, 0x0b4000ff, 0x000f07a0, 0x07000fff, 0x00000000, 
	0x00000007, 0x000726f0, 0x0bcb0ba9, 0x0b770700, 0x0b4000ff, 0x000f07a0, 0x07000fff, 0x00000000, 
	0x00000000, 0x0ddd0bbb, 0x09990888, 0x07770666, 0x05550444, 0x03330000, 0x00000000, 0x00000000, 
	0x00000000, 0x0ddd0bbb, 0x09990888, 0x07770666, 0x05550444, 0x03330000, 0x00000000, 0x00000000, 
	0x00000000, 0x0ddd0bbb, 0x09990888, 0x07770666, 0x05550444, 0x03330000, 0x00000000, 0x00000000, 
	0x00000007, 0x00070400, 0x0bcb0ba9, 0x0b770700, 0x0b4000ff, 0x000f07a0, 0x07000fff, 0x00000000, 
	0x00000000, 0x03100412, 0x0cc50722, 0x07640b86, 0x0da70fff, 0x0aaa0ccc, 0x000b0888, 0x00000000, 
	0x00000000, 0x03100412, 0x0cc50722, 0x07640b86, 0x0da70fff, 0x0aaa0ccc, 0x000b0000, 0x08880000, 
	0x00000dee, 0x0dee09aa, 0x0cdd0bcc, 0x09ab09ab, 0x0efe0eff, 0x0eff0bce, 0x0fff09aa, 0x0abb0000, 
	0x00000032, 0x00630085, 0x00870098, 0x00a900cb, 0x07ca08cb, 0x000c0000, 0x00000000, 0x00000000, 
	0x0000008a, 0x0088009a, 0x00bb0080, 0x0bff08be, 0x007907bd, 0x09bb078a, 0x0bbb009c, 0x00680000, 
	0x00000ef0, 0x0ef00000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000ef0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x00000888, 0x09990aaa, 0x0bbb0ccc, 0x0ddd0eee, 0x00000000, 0x00000000, 0x00000000, 
	0x00000ffe, 0x0fde0fee, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee0000f, 0x000d000b, 0x0ade0fff, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000fff, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000ddf, 0x00000000, 
	0x00000fbe, 0x0fde0eec, 0x0bf60be0, 0x0fce0ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x00000000, 
	0x00000fce, 0x0fde0eec, 0x0bf60be0, 0x0fde0ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x00000000, 
	0x00000fde, 0x0eec0bf6, 0x0be00fbe, 0x0fce0ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x00000000, 
	0x00000eec, 0x0bf60be0, 0x0fbe0fce, 0x0fde0ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x00000000, 
	0x00000bf6, 0x0be00fbe, 0x0fce0fde, 0x0eec0ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x00000000, 
	0x00000be0, 0x0fbe0fce, 0x0fde0eec, 0x0bf60ccc, 0x0bab07b0, 0x0890099b, 0x09ab0abc, 0x00000000, 
	0x00000000, 0x00a000ba, 0x078a0679, 0x04580035, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00a000ba, 0x0bef0adf, 0x09bd08ac, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00a000ba, 0x00cd00bd, 0x00ad069b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00a000ba, 0x06b906a8, 0x06970686, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x0fe00fc0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000bcd, 0x0abc09a8, 0x089a0789, 0x00bd00ac, 0x009b008a, 0x00000000, 0x00000000, 0x00000000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee00ec0, 0x0ec00ec0, 0x00000fff, 0x00000000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee00fff, 0x0ec00ec0, 0x00000fff, 0x00000000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee00fff, 0x0fff0ec0, 0x00000fff, 0x00000000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee00fff, 0x0fff0fff, 0x00000fff, 0x00000000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee00ec0, 0x0fff0fff, 0x00000fff, 0x00000000, 
	0x00000ffe, 0x0fee0fde, 0x0fcd0eb0, 0x0ec00ed0, 0x0ee00ec0, 0x0ec00fff, 0x00000fff, 0x00000000, 
	0x000000ce, 0x00ef0bdf, 0x0acf09bd, 0x08ac098d, 0x098d086b, 0x00000e67, 0x089a009b, 0x00000000, 
	0x00000000, 0x07770889, 0x089a0abc, 0x09ab0bcd, 0x0cde0000, 0x0fff0abc, 0x0abc0abc, 0x0abc0000, 
	0x00000000, 0x00000555, 0x0667089a, 0x09ab7abc, 0x7bcd0000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x05550667, 0x07770789, 0x09ab7abc, 0x7bcd0000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000008, 0x033a055c, 0x067d088d, 0x0aad0ddd, 0x0bbb0aaa, 0x007d0008, 0x00000999, 0x07770000, 
	0x00000fff, 0x000f080f, 0x0e0e0f0b, 0x0f0000ff, 0x00000cbb, 0x00000a97, 0x0c980ced, 0x00000000, 
	0x00000fff, 0x008f000e, 0x000c0f80, 0x0baa00ff, 0x0dcc0cbb, 0x0acc0a97, 0x08b00ced, 0x00000000, 
	0x00000fff, 0x0e900eb0, 0x0ec00fd0, 0x0ff00d00, 0x0d0b0cbb, 0x0cdd0bab, 0x0a800dff, 0x00000000, 
	0x000000f0, 0x00f000f0, 0x000f000f, 0x000f000f, 0x00f000f0, 0x00f0000f, 0x000f000f, 0x000f0000, 
	0x000000f0, 0x00f000f0, 0x000f000f, 0x000f0000, 0x00f000f0, 0x00f0000f, 0x000f000f, 0x00000000, 
	0x000000f0, 0x00f000f0, 0x000f000f, 0x00000000, 0x00f000f0, 0x00f0000f, 0x000f0000, 0x00000000, 
	0x000000f0, 0x00f000f0, 0x000f0000, 0x00000000, 0x00f000f0, 0x00f0000f, 0x00000000, 0x00000000, 
	0x000000f0, 0x00f000f0, 0x00000000, 0x00000000, 0x00f000f0, 0x00f00000, 0x00000000, 0x00000000, 
	0x000000f0, 0x00f00000, 0x00000000, 0x00000000, 0x00f000f0, 0x00000000, 0x00000000, 0x00000000, 
	0x000000f0, 0x00000000, 0x00000000, 0x00000000, 0x00f00000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000aef, 0x09df08cf, 0x07be00ad, 0x009c008c, 0x0fff0000, 0x00000000, 0x00000000, 0x0dff0000, 
	0x00000fff, 0x00f0000f, 0x00000888, 0x09990aaa, 0x0bbb0ccc, 0x0ddd00f0, 0x00f0000f, 0x00f00000, 
	0x00000fff, 0x00f00000, 0x00000888, 0x09990aaa, 0x0bbb0ccc, 0x0ddd0000, 0x000000f0, 0x000f0000, 
	0x00000065, 0x008a089b, 0x09ab0abc, 0x0abd0bce, 0x0bdf0cdf, 0x030f0000, 0x00000000, 0x00000000, 
	0x000009ba, 0x00bc00ab, 0x008a007a, 0x0097088a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000ace, 0x09bd07ac, 0x069b07ab, 0x048a0368, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000cef, 0x0bef0bde, 0x0ace09bd, 0x09ac089b, 0x06790000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x0efe0eed, 0x0ddb0dc9, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000667, 0x079b08ac, 0x0acf08bd, 0x079b0cef, 0x0bce0bbb, 0x0000069b, 0x06bd0cef, 0x0cde0000, 
	0x00000cdc, 0x0aaa0aa9, 0x0ccc0bbb, 0x0ddd0ffe, 0x0eed0eed, 0x00db0bcc, 0x0dee0ccd, 0x0bbb0000, 
	0x00000eed, 0x0cbb0cbf, 0x0cce0ecc, 0x0edc0ddb, 0x0cdc0cb9, 0x0bbb0ffd, 0x0eca0dce, 0x0bad0000, 
	0x00000fff, 0x0eee0ddd, 0x0ff0000f, 0x000c0000, 0x000f000c, 0x00d00000, 0x000a00de, 0x00bd0000, 
	0x00000c90, 0x00000bdf, 0x08ce09ad, 0x06c00890, 0x055f066b, 0x00000c9e, 0x096c00ee, 0x0fc00000, 
	0x00000000, 0x00000f60, 0x0f600f60, 0x000f0000, 0x00000000, 0x00000000, 0x00000fff, 0x0f600000, 
	0x00000bce, 0x0abd0aab, 0x07890000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000561, 0x0cef0bdf, 0x0abf099c, 0x077a0778, 0x060e050a, 0x00000800, 0x0fff0dbc, 0x0a8a0000, 
	0x00000000, 0x0cdf0bdf, 0x0abf088d, 0x077b009e, 0x05690b97, 0x00000970, 0x0db00fff, 0x09880000, 
	0x00000000, 0x0cdf0bdf, 0x0abf09ac, 0x077b077a, 0x09790950, 0x00000805, 0x09be0eff, 0x0b980000, 
	0x00000000, 0x0cef0bef, 0x0acf099c, 0x077b0779, 0x000e0750, 0x0000010b, 0x09be0a80, 0x0a080000, 
	0x000009ce, 0x0adf0ace, 0x09ce09cd, 0x0abd0abc, 0x09df09cc, 0x000009ac, 0x089b09bc, 0x0bde0000, 
	0x0000000d, 0x00fe0ace, 0x09bd089c, 0x0000007b, 0x00480fff, 0x010f0edd, 0x0dbb0888, 0x007a0000, 
	0x00000c90, 0x09ae067d, 0x0dff0acd, 0x09bc09cd, 0x07890dff, 0x0f990c90, 0x0efe0fed, 0x0dd00000, 
	0x0000008e, 0x0dd00a80, 0x0dff0bbf, 0x099e0aad, 0x088b0dff, 0x0000008e, 0x00000efe, 0x0dd00000, 
	0x000008d0, 0x00be007b, 0x0dff0cc0, 0x0bb00bb0, 0x08800dff, 0x000008d0, 0x00000efe, 0x0fed0000, 
	0x00000bba, 0x0bba0998, 0x0bba00bd, 0x00ac008b, 0x00780dff, 0x00000bba, 0x00000fed, 0x0dd00000, 
	0x00000000, 0x00130025, 0x00470059, 0x087b0aac, 0x0fff0fff, 0x00000bda, 0x00000888, 0x00000000, 
	0x00000000, 0x00130025, 0x00470059, 0x087b0aac, 0x0fff0fff, 0x00000bda, 0x00000000, 0x08880000, 
	0x00000000, 0x05300955, 0x0a660b88, 0x0d990dbb, 0x0ddd000a, 0x00000dd9, 0x00000888, 0x00000000, 
	0x00000000, 0x05300955, 0x0a660b88, 0x0d990dbb, 0x0ddd000a, 0x00000dd9, 0x00000000, 0x08880000, 
	0x00000065, 0x008a089b, 0x09ab0abc, 0x0abd0bce, 0x0bdf0cdf, 0x030f0000, 0x00000000, 0x00000000, 
	0x00000eff, 0x0eee0edd, 0x0ecc0ecc, 0x0ecc0ecc, 0x0ecc0000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000068, 0x00f008cf, 0x08be089c, 0x089b0bee, 0x09ce0ad9, 0x0fff008e, 0x007b09b9, 0x0fff0000, 
	0x00000000, 0x03530565, 0x0cc80585, 0x049406b8, 0x09ca0ccc, 0x07770999, 0x00080777, 0x00000000, 
	0x00000000, 0x03530565, 0x0cc80585, 0x049406b8, 0x09ca0ccc, 0x07770999, 0x00080777, 0x00000000, 
	0x00000777, 0x07770777, 0x07770777, 0x07770777, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0777, 0x07770777, 0x07770777, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x07770777, 0x07770777, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0777, 0x07770777, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x07770777, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x0bbb0777, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x0bbb0bbb, 0x0fff050a, 0x0eee0777, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x0bbb0bbb, 0x0fff050a, 0x0eee0bbb, 0x07770777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x0bbb0bbb, 0x0fff050a, 0x0eee0bbb, 0x0bbb0777, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x0bbb0bbb, 0x0fff050a, 0x0eee0bbb, 0x0bbb0bbb, 0x07770000, 
	0x00000777, 0x0bbb0bbb, 0x0bbb0bbb, 0x0bbb0bbb, 0x0fff050a, 0x0eee0bbb, 0x0bbb0bbb, 0x0bbb0000, 
	0x00000034, 0x02450467, 0x06780577, 0x06770688, 0x07980788, 0x08750000, 0x00000000, 0x00000000, 
	0x00000000, 0x0ddd0bbb, 0x09990888, 0x07770666, 0x05550444, 0x03330000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
	0x00000222, 0x08be07ad, 0x069b0efe, 0x0ccc0bbb, 0x0cdd0bcb, 0x00000efe, 0x0abc0a9b, 0x08890000, 
	0x000007cc, 0x0bef08cf, 0x07be05ac, 0x039b0068, 0x0cdd0bcb, 0x00000eff, 0x0ccc09ac, 0x05bb0000, 
	0x00000000, 0x0009000b, 0x000d000f, 0x0aaf0bbf, 0x0ccf0fff, 0x0ffc00ff, 0x00000000, 0x00000000, 
	0x00000000, 0x07770889, 0x089a0abc, 0x09ab0bcd, 0x0cde0fff, 0x0aaa0000, 0x00000000, 0x00000000, 
	0x00000000, 0x07770889, 0x089a0abc, 0x09ab0bcd, 0x0cde0fff, 0x00000000, 0x00000000, 0x00000000, 
	0x00000678, 0x079a09ab, 0x0abc09bb, 0x0aba0acc, 0x00000000, 0x099b0000, 0x08cd099b, 0x08cc0000, 
	0x00000000, 0x07660855, 0x0dd90c77, 0x0d990dbb, 0x0dcc0ddd, 0x08880aaa, 0x00090888, 0x00000000, 
	0x00000adf, 0x08cd07bd, 0x07ad078c, 0x006a0008, 0x00590048, 0x00000000, 0x00000000, 0x00000000, 
	0x00000000, 0x0fff4efd, 0x4ce00ce0, 0x4ac04cfc, 0x49b00ec9, 0x0eb80ea9, 0x0cc00cd9, 0x0dfb0000, 
	0x00000067, 0x008b0adf, 0x08be078b, 0x0eba0a88, 0x0a7c0759, 0x00000fff, 0x0079096b, 0x00be0000, 
	0x00000068, 0x009b0bdf, 0x09ce077b, 0x086d066b, 0x0ac707b0, 0x00f00fff, 0x00660099, 0x00ee0000, 
	0x0000019b, 0x09ce0bdf, 0x09be099c, 0x00a0008f, 0x00480018, 0x00f00caa, 0x0bbf0980, 0x00000000, 
	0x00000def, 0x0ace0ace, 0x0bde0bef, 0x000009bd, 0x09ac089b, 0x06790000, 0x00000000, 0x00000000, 
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0eef0ddf, 0x00000ccf, 0x0bbf0aaf, 0x099f0000, 
	0x00000000, 0x00000000, 0x00000998, 0x000f00df, 0x00000ccb, 0x00000000, 0x00000000, 0x00000000, 
	0x00000fff, 0x0ffc0fe9, 0x0fca0998, 0x000f00df, 0x0eee0ccb, 0x09d006a4, 0x0679079b, 0x0bff0000, 
	0x00000fff, 0x0ffc0fe9, 0x0fca0998, 0x000f00df, 0x0eee0ccb, 0x09d006a4, 0x0679079b, 0x0bfb0000, 
	0x00000fff, 0x0ffc0fe9, 0x0fca0998, 0x000f00df, 0x0eee0ccb, 0x09d006a4, 0x0679079b, 0x03780000, 
	0x00000fff, 0x0ffc0fe9, 0x0fca0aaa, 0x059f00ef, 0x0be70ccb, 0x000006a4, 0x087f09ad, 0x087f0000, 
	0x00000000, 0x089a0abc, 0x0089009b, 0x008c00bd, 0x0bde0def, 0x0eee0cdf, 0x00d000f7, 0x00b00000, 
	0x00000fff, 0x08eb04c7, 0x08b2099c, 0x039b03ad, 0x0ccb0090, 0x068007ad, 0x099a0777, 0x046b0000, 
	0x00000000, 0x0ffb0fdb, 0x00aa0eeb, 0x0caf0ecf, 0x007a009c, 0x009000c0, 0x00f00fff, 0x000f0000, 
	0x00000000, 0x0079008a, 0x00ad0fff, 0x0000059c, 0x00bb00bc, 0x00be0bdf, 0x09990bbb, 0x0ddd0000, 
	0x00000000, 0x089a0abc, 0x0089009b, 0x00ac00bd, 0x0bde0def, 0x0eee0079, 0x008b00ad, 0x00be0000, 
	0x00000444, 0x065d0892, 0x09a30ac5, 0x0bc90ddd, 0x0cbb0b99, 0x009d000b, 0x00000888, 0x00000000, 
	0x00000444, 0x065d0892, 0x09a30ac5, 0x0bc90ddd, 0x0cbb0b99, 0x009d000b, 0x00000000, 0x08880000, 
	0x00000000, 0x05560326, 0x05570448, 0x055a0ddd, 0x0cca0998, 0x008c0009, 0x00000888, 0x00000000, 
	0x00000000, 0x05560326, 0x05570448, 0x055a0ddd, 0x0cca0998, 0x008c0009, 0x00000000, 0x08880000, 
	0x00000056, 0x0078019a, 0x00bc07cd, 0x09cd0ddd, 0x0bbb0999, 0x008c0009, 0x00000888, 0x00000000, 
	0x00000056, 0x0078019a, 0x00bc07cd, 0x09cd0ddd, 0x0bbb0999, 0x008c0009, 0x00000000, 0x08880000, 
	0x00000000, 0x08dd0040, 0x03600690, 0x0ac70dec, 0x069b0008, 0x008c000c, 0x00000888, 0x00000000, 
	0x00000000, 0x08dd0040, 0x03600690, 0x0ac70dec, 0x069b0008, 0x008c000c, 0x00000000, 0x08880000, 
	0x00000ade, 0x088a099b, 0x08ac06ad, 0x07bd088b, 0x099a08bd, 0x000007ab, 0x067905cf, 0x0acd0000,
	0x00000800, 0x0a330c55, 0x0d660d88, 0x0daa0ddd, 0x09ab089a, 0x007d0008, 0x00000888, 0x06660000,	// Palette 256: Blue Ferrari. No Brake Lamp / Tyre Pattern A
	0x00000800, 0x0a330c55, 0x0d660d88, 0x0daa0ddd, 0x09ab089a, 0x007d0008, 0x00000666, 0x08880000, // Palette 257: Blue Ferrari. No Brake Lamp / Tyre Pattern B	
	0x00000800, 0x0a330c55, 0x0d660d88, 0x0daa0ddd, 0x09ab089a, 0x007d000f, 0x00000888, 0x06660000, // Palette 258: Blue Ferrari. Brake Lamp On / Tyre Pattern A	
	0x00000800, 0x0a330c55, 0x0d660d88, 0x0daa0ddd, 0x09ab089a, 0x007d000f, 0x00000666, 0x08880000, // Palette 259: Blue Ferrari. Brake Lamp On / Tyre Pattern B
	0x00000000, 0x0ffc0777, 0x08880999, 0x0aaa0bbb, 0x0ccc0ddd, 0x0fff0daa, 0x0d880d66, 0x0c550000, // Palette 260: Blue Ferrari. Flip (11=6, 12=5, 13=4, 14=3 from normal palette)
	0x00000056, 0x0078019a, 0x00bc07cd, 0x09cd0ddd, 0x09ab089a, 0x007d0008, 0x00000888, 0x06660000,	// Palette 261: Yellow Ferrari. No Brake Lamp / Tyre Pattern A
	0x00000056, 0x0078019a, 0x00bc07cd, 0x09cd0ddd, 0x09ab089a, 0x007d0008, 0x00000666, 0x08880000, // Palette 262: Yellow Ferrari. No Brake Lamp / Tyre Pattern B	
	0x00000056, 0x0078019a, 0x00bc07cd, 0x09cd0ddd, 0x09ab089a, 0x007d000f, 0x00000888, 0x06660000, // Palette 263: Yellow Ferrari. Brake Lamp On / Tyre Pattern A	
	0x00000056, 0x0078019a, 0x00bc07cd, 0x09cd0ddd, 0x09ab089a, 0x007d000f, 0x00000666, 0x08880000, // Palette 264: Yellow Ferrari. Brake Lamp On / Tyre Pattern B
	0x00000000, 0x0ddd0ccc, 0x0bbb0aaa, 0x09990888, 0x07770fff, 0x00000079, 0x008a009b, 0x00ac0000, // Palette 265: Yellow Ferrari. Flip (11=6, 12=5, 13=4, 14=3 from normal palette)
	0x00006250, 0x048004a0, 0x65b027c0, 0x48d00ddd, 0x09ab089a, 0x007d0008, 0x00000888, 0x06660000,	// Palette 266: Green Ferrari. No Brake Lamp / Tyre Pattern A
	0x00006250, 0x048004a0, 0x65b027c0, 0x48d00ddd, 0x09ab089a, 0x007d0008, 0x00000666, 0x08880000, // Palette 267: Green Ferrari. No Brake Lamp / Tyre Pattern B	
	0x00006250, 0x048004a0, 0x65b027c0, 0x48d00ddd, 0x09ab089a, 0x007d000f, 0x00000888, 0x06660000, // Palette 268: Green Ferrari. Brake Lamp On / Tyre Pattern A	
	0x00006250, 0x048004a0, 0x65b027c0, 0x48d00ddd, 0x09ab089a, 0x007d000f, 0x00000666, 0x08880000, // Palette 269: Green Ferrari. Brake Lamp On / Tyre Pattern B
	0x00000444, 0x05550555, 0x06660777, 0x09990ccc, 0x0ccc0ddd, 0x0fff48d0, 0x27c065b0, 0x04a00000, // Palette 270: Green Ferrari. Flip (11=6, 12=5, 13=4, 14=3 from normal palette)
	0x00006650, 0x67626a94, 0x6ba54bb7, 0x2cb90ddd, 0x09ab089a, 0x007d0008, 0x00000888, 0x06660000,	// Palette 271: Cyan Ferrari. No Brake Lamp / Tyre Pattern A
	0x00006650, 0x67626a94, 0x6ba54bb7, 0x2cb90ddd, 0x09ab089a, 0x007d0008, 0x00000666, 0x08880000, // Palette 272: Cyan Ferrari. No Brake Lamp / Tyre Pattern B	
	0x00006650, 0x67626a94, 0x6ba54bb7, 0x2cb90ddd, 0x09ab089a, 0x007d000f, 0x00000888, 0x06660000, // Palette 273: Cyan Ferrari. Brake Lamp On / Tyre Pattern A	
	0x00006650, 0x67626a94, 0x6ba54bb7, 0x2cb90ddd, 0x09ab089a, 0x007d000f, 0x00000666, 0x08880000, // Palette 274: Cyan Ferrari. Brake Lamp On / Tyre Pattern B
	0x00000000, 0x0ffc0777, 0x08880999, 0x0aaa0bbb, 0x0ccc0ddd, 0x0fff2cb9, 0x4bb76ba5, 0x6a940000, // Palette 275: Cyan Ferrari. Flip (11=6, 12=5, 13=4, 14=3 from normal palette)
};

const static int PAL_LOOKUP_LENGTH = (sizeof(PALETTE_EXPANSION) / sizeof(PALETTE_EXPANSION[0])) / 8;

/*
   We can generate the 'flip palette' colours for the Ferrari from an existing car palette as follows:

   #include <iostream>
   #include  <iomanip>

   void generate()
   {
	   int src_offset = 111 * 8; // source palette to use (111)
	   int col_offset = OFerrari::PAL_CYAN * 8; // new colours to apply

	   uint32_t c1 = PALETTE_EXPANSION[src_offset++]; // bytes 0  - 3
	   uint32_t c2 = PALETTE_EXPANSION[src_offset++]; // bytes 4  - 7
	   uint32_t c3 = PALETTE_EXPANSION[src_offset++]; // bytes 8  - 11
	   uint32_t c4 = PALETTE_EXPANSION[src_offset++]; // bytes 12 - 15
	   uint32_t c5 = PALETTE_EXPANSION[src_offset++]; // bytes 16 - 19
	   uint32_t c6 = PALETTE_EXPANSION[src_offset++]; // bytes 20 - 23 (0x0fff0aaf)
	   uint32_t c7 = PALETTE_EXPANSION[src_offset++]; // bytes 24 - 27
	   uint32_t c8 = PALETTE_EXPANSION[src_offset++]; // bytes 28 - 31

	   uint32_t o1 = PALETTE_EXPANSION[col_offset++]; // bytes 0  - 3 
	   uint32_t o2 = PALETTE_EXPANSION[col_offset++]; // bytes 4  - 7
	   uint32_t o3 = PALETTE_EXPANSION[col_offset++]; // bytes 8  - 11
	   uint32_t o4 = PALETTE_EXPANSION[col_offset++]; // bytes 12  - 15 (0x0daa0ddd)

	   c6 = (c6 & 0xFFFF0000) | ((o4 & 0xFFFF0000) >> 16); // word 11 = word 6
	   c7 = (c7 & 0x0000FFFF) | ((o3 & 0x0000FFFF) << 16); // word 12 = word 5
	   c7 = (c7 & 0xFFFF0000) | ((o3 & 0xFFFF0000) >> 16); // word 13 = word 4
	   c8 = (c8 & 0x0000FFFF) | ((o2 & 0x0000FFFF) << 16); // word 14 = word 3

	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c1 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c2 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c3 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c4 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c5 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c6 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c7 << ", ";
	   std::cout << std::hex << "0x" << std::setfill('0') << std::setw(8) << c8 << std::endl;
   }
*/	
