/***************************************************************************
    Patched version of zoom lookup table which fixes sprite zoom bug.
    
    This is used to scale all sprites in the game. 
    
    The original game features a bug, which causes sprites at certain z 
    positions to be scaled incorrectly.
***************************************************************************/

#include "stdint.hpp"

// Format is: vzoom & hzoom, width/height lookup, sprite size to use, unused
// (0x200 = full size, 0x100 = half size, 0x300 = 2x size)

// Example sizes:
// Cactus 5 (largest): 94 pixels
// Cactus 4          : 46 pixels
// Cactus 3          : 23 pixels
// Cactus 2          : 12 pixels
// Cactus 1          :  4 pixels

const static uint16_t SIZE5 = 0x0028; // Smallest Sprite
const static uint16_t SIZE4 = 0x001E;
const static uint16_t SIZE3 = 0x0014; // Medium Sprite
const static uint16_t SIZE2 = 0x000A;
const static uint16_t SIZE1 = 0x0000; // Largest Sprite

const static uint16_t UNUSED = 0x0000;

const static uint16_t ZOOM_LOOKUP[] =
{
    // Smallest Sprite In Set
    0x03F0, 0x0000, SIZE5, UNUSED,
    0x03F0, 0x0000, SIZE5, UNUSED,
    0x03F0, 0x0000, SIZE5, UNUSED,
    0x03F0, 0x0000, SIZE5, UNUSED,
    0x0329, 0x1000, SIZE5, UNUSED,
    0x02A3, 0x2000, SIZE5, UNUSED,
    0x0243, 0x3000, SIZE5, UNUSED,
  
    0x03F0, 0x0000, SIZE4, UNUSED,
    0x0381, 0x0800, SIZE4, UNUSED,
    0x0329, 0x1000, SIZE4, UNUSED,
    0x02E0, 0x1800, SIZE4, UNUSED,
    0x02A3, 0x2000, SIZE4, UNUSED,
    0x0270, 0x2800, SIZE4, UNUSED,
    0x0243, 0x3000, SIZE4, UNUSED,
    0x021B, 0x3800, SIZE4, UNUSED,
  
    0x03F0, 0x0000, SIZE3, UNUSED,
    0x03B5, 0x0400, SIZE3, UNUSED,
    0x0381, 0x0800, SIZE3, UNUSED,
    0x0353, 0x0C00, SIZE3, UNUSED,
    0x0329, 0x1000, SIZE3, UNUSED,
    0x0303, 0x1400, SIZE3, UNUSED,
    0x02E0, 0x1800, SIZE3, UNUSED,
    0x02C0, 0x1C00, SIZE3, UNUSED,
    0x02A3, 0x2000, SIZE3, UNUSED,
    0x0288, 0x2400, SIZE3, UNUSED,
    0x0270, 0x2800, SIZE3, UNUSED,
    0x0259, 0x2C00, SIZE3, UNUSED,
    0x0243, 0x3000, SIZE3, UNUSED,
    0x0230, 0x3400, SIZE3, UNUSED,
    0x021B, 0x3800, SIZE3, UNUSED,
    0x020C, 0x3C00, SIZE3, UNUSED,

    0x03F0, 0x0000, SIZE2, UNUSED,
    0x03D2, 0x0200, SIZE2, UNUSED,
    0x03B5, 0x0400, SIZE2, UNUSED,
    0x039B, 0x0600, SIZE2, UNUSED,
    0x0381, 0x0800, SIZE2, UNUSED,
    0x0369, 0x0A00, SIZE2, UNUSED,
    0x0353, 0x0C00, SIZE2, UNUSED,
    0x033D, 0x0E00, SIZE2, UNUSED,
    0x0329, 0x1000, SIZE2, UNUSED,
    0x0315, 0x1200, SIZE2, UNUSED,
    0x0303, 0x1400, SIZE2, UNUSED,
    0x02F1, 0x1600, SIZE2, UNUSED,
    0x02E0, 0x1800, SIZE2, UNUSED,
    0x02D0, 0x1A00, SIZE2, UNUSED,
    0x02C0, 0x1C00, SIZE2, UNUSED,
    0x02B1, 0x1E00, SIZE2, UNUSED,
    0x02A3, 0x2000, SIZE2, UNUSED,
    0x0295, 0x2200, SIZE2, UNUSED,
    0x0288, 0x2400, SIZE2, UNUSED,
    0x027C, 0x2600, SIZE2, UNUSED,
    0x0270, 0x2800, SIZE2, UNUSED,
    0x0264, 0x2A00, SIZE2, UNUSED,
    0x0259, 0x2C00, SIZE2, UNUSED,
    0x024E, 0x2E00, SIZE2, UNUSED,
    0x0243, 0x3000, SIZE2, UNUSED,
    0x0239, 0x3200, SIZE2, UNUSED,
    0x0230, 0x3400, SIZE2, UNUSED,
    0x0226, 0x3600, SIZE2, UNUSED,
    0x021B, 0x3800, SIZE2, UNUSED,
    0x0214, 0x3A00, SIZE2, UNUSED,
    0x020C, 0x3C00, SIZE2, UNUSED,
    0x0204, 0x3E00, SIZE2, UNUSED,
   
    0x03F0, 0x0000, SIZE1, UNUSED,
    0x03F0, 0x0000, SIZE1, UNUSED,
    0x03E0, 0x0100, SIZE1, UNUSED,
    0x03D2, 0x0200, SIZE1, UNUSED,
    // 0x032C, 0x0300, SIZE1, UNUSED,
    // 0x03B5, 0x0400, SIZE1, UNUSED,
    0x03C2, 0x0300, SIZE1, UNUSED, // Replaced value
    0x03B6, 0x0400, SIZE1, UNUSED, // Replaced value
    0x03A8, 0x0500, SIZE1, UNUSED,
    0x039B, 0x0600, SIZE1, UNUSED,
    0x038E, 0x0700, SIZE1, UNUSED,
    0x0381, 0x0800, SIZE1, UNUSED,
    0x0375, 0x0900, SIZE1, UNUSED,
    0x0369, 0x0A00, SIZE1, UNUSED,
    0x035E, 0x0B00, SIZE1, UNUSED,
    0x0353, 0x0C00, SIZE1, UNUSED,
    0x0348, 0x0D00, SIZE1, UNUSED,
    0x033D, 0x0E00, SIZE1, UNUSED,
    0x0333, 0x0F00, SIZE1, UNUSED,
    0x0329, 0x1000, SIZE1, UNUSED,
    0x031F, 0x1100, SIZE1, UNUSED,
    0x0315, 0x1200, SIZE1, UNUSED,
    0x030C, 0x1300, SIZE1, UNUSED,
    0x0303, 0x1400, SIZE1, UNUSED,
    0x02FA, 0x1500, SIZE1, UNUSED,
    0x02F1, 0x1600, SIZE1, UNUSED,
    0x02E8, 0x1700, SIZE1, UNUSED,
    0x02E0, 0x1800, SIZE1, UNUSED,
    0x02D8, 0x1900, SIZE1, UNUSED,
    0x02D0, 0x1A00, SIZE1, UNUSED,
    0x02D8, 0x1B00, SIZE1, UNUSED,
    0x02C0, 0x1C00, SIZE1, UNUSED,
    0x02B9, 0x1D00, SIZE1, UNUSED,
    0x02B1, 0x1E00, SIZE1, UNUSED,
    0x02AA, 0x1F00, SIZE1, UNUSED,
    0x02A3, 0x2000, SIZE1, UNUSED,
    0x029C, 0x2100, SIZE1, UNUSED,
    0x0295, 0x2200, SIZE1, UNUSED,
    0x028F, 0x2300, SIZE1, UNUSED,
    0x0288, 0x2400, SIZE1, UNUSED,
    0x0282, 0x2500, SIZE1, UNUSED,
    0x027C, 0x2600, SIZE1, UNUSED,
    0x0276, 0x2700, SIZE1, UNUSED,
    0x0270, 0x2800, SIZE1, UNUSED,
    0x026A, 0x2900, SIZE1, UNUSED,
    0x0264, 0x2A00, SIZE1, UNUSED,
    0x025E, 0x2B00, SIZE1, UNUSED,
    0x0259, 0x2C00, SIZE1, UNUSED,
    0x0253, 0x2D00, SIZE1, UNUSED,
    0x024E, 0x2E00, SIZE1, UNUSED,
    0x0249, 0x2F00, SIZE1, UNUSED,
    0x0243, 0x3000, SIZE1, UNUSED,
    0x023E, 0x3100, SIZE1, UNUSED,
    0x0239, 0x3200, SIZE1, UNUSED,
    0x0234, 0x3300, SIZE1, UNUSED,
    0x0230, 0x3400, SIZE1, UNUSED,
    0x022B, 0x3500, SIZE1, UNUSED,
    0x0226, 0x3600, SIZE1, UNUSED,
    0x0222, 0x3700, SIZE1, UNUSED,
    0x021B, 0x3800, SIZE1, UNUSED,
    0x0219, 0x3900, SIZE1, UNUSED,
    0x0214, 0x3A00, SIZE1, UNUSED,
    0x0210, 0x3B00, SIZE1, UNUSED,
    0x020C, 0x3C00, SIZE1, UNUSED,
    0x0208, 0x3D00, SIZE1, UNUSED,
    0x0204, 0x3E00, SIZE1, UNUSED,
    0x0200, 0x3F00, SIZE1, UNUSED,
    0x01F8, 0x4000, SIZE1, UNUSED,
    0x01F8, 0x4000, SIZE1, UNUSED,
    0x01F0, 0x4100, SIZE1, UNUSED,
    0x01F0, 0x4100, SIZE1, UNUSED,
    0x01E9, 0x4200, SIZE1, UNUSED,
    0x01E9, 0x4200, SIZE1, UNUSED,
    0x01E1, 0x4300, SIZE1, UNUSED,
    0x01E1, 0x4300, SIZE1, UNUSED,
    0x01DA, 0x4400, SIZE1, UNUSED,
    0x01DA, 0x4400, SIZE1, UNUSED,
    0x01D4, 0x4500, SIZE1, UNUSED,
    0x01D4, 0x4500, SIZE1, UNUSED,
    0x01CD, 0x4600, SIZE1, UNUSED,
    0x01CD, 0x4600, SIZE1, UNUSED,
    0x01C7, 0x4700, SIZE1, UNUSED,
    0x01C7, 0x4700, SIZE1, UNUSED,
    0x01C0, 0x4800, SIZE1, UNUSED,
    0x01C0, 0x4800, SIZE1, UNUSED,
    0x01BA, 0x4900, SIZE1, UNUSED,
    0x01BA, 0x4900, SIZE1, UNUSED,
    0x01B4, 0x4A00, SIZE1, UNUSED,
    0x01B4, 0x4A00, SIZE1, UNUSED,
    0x01AF, 0x4B00, SIZE1, UNUSED,
    0x01AF, 0x4B00, SIZE1, UNUSED,
    0x01A9, 0x4C00, SIZE1, UNUSED,
    0x01A9, 0x4C00, SIZE1, UNUSED,
    0x01A4, 0x4D00, SIZE1, UNUSED,
    0x01A4, 0x4D00, SIZE1, UNUSED,
    0x019E, 0x4E00, SIZE1, UNUSED,
    0x019E, 0x4E00, SIZE1, UNUSED,
    0x0199, 0x4F00, SIZE1, UNUSED,
    0x0199, 0x4F00, SIZE1, UNUSED,
    0x0194, 0x5000, SIZE1, UNUSED,
    0x0194, 0x5000, SIZE1, UNUSED,
    0x018F, 0x5100, SIZE1, UNUSED,
    0x018F, 0x5100, SIZE1, UNUSED,
    0x018A, 0x5200, SIZE1, UNUSED,
    0x018A, 0x5200, SIZE1, UNUSED,
    0x0186, 0x5300, SIZE1, UNUSED,
    0x0186, 0x5300, SIZE1, UNUSED,
    0x0181, 0x5400, SIZE1, UNUSED,
    0x0181, 0x5400, SIZE1, UNUSED,
    0x017D, 0x5500, SIZE1, UNUSED,
    0x017D, 0x5500, SIZE1, UNUSED,
    0x0178, 0x5600, SIZE1, UNUSED,
    0x0178, 0x5600, SIZE1, UNUSED,
    0x0174, 0x5700, SIZE1, UNUSED,
    0x0174, 0x5700, SIZE1, UNUSED,
    0x0170, 0x5800, SIZE1, UNUSED,
    0x0170, 0x5800, SIZE1, UNUSED,
    0x016C, 0x5900, SIZE1, UNUSED,
    0x016C, 0x5900, SIZE1, UNUSED,
    0x0168, 0x5A00, SIZE1, UNUSED,
    0x0168, 0x5A00, SIZE1, UNUSED,
    0x0164, 0x5B00, SIZE1, UNUSED,
    0x0164, 0x5B00, SIZE1, UNUSED,
    0x0160, 0x5C00, SIZE1, UNUSED,
    0x0160, 0x5C00, SIZE1, UNUSED,
    0x015C, 0x5D00, SIZE1, UNUSED,
    0x015C, 0x5D00, SIZE1, UNUSED,
    0x0158, 0x5E00, SIZE1, UNUSED,
    0x0158, 0x5E00, SIZE1, UNUSED,
    0x0155, 0x5F00, SIZE1, UNUSED,
    0x0155, 0x5F00, SIZE1, UNUSED,
    0x0151, 0x6000, SIZE1, UNUSED,
    0x0151, 0x6000, SIZE1, UNUSED,
    0x014E, 0x6100, SIZE1, UNUSED,
    0x014E, 0x6100, SIZE1, UNUSED,
    0x014A, 0x6200, SIZE1, UNUSED,
    0x014A, 0x6200, SIZE1, UNUSED,
    0x0147, 0x6300, SIZE1, UNUSED,
    0x0147, 0x6300, SIZE1, UNUSED,
    0x0144, 0x6400, SIZE1, UNUSED,
    0x0144, 0x6400, SIZE1, UNUSED,
    0x0141, 0x6500, SIZE1, UNUSED,
    0x0141, 0x6500, SIZE1, UNUSED,
    0x013E, 0x6600, SIZE1, UNUSED,
    0x013E, 0x6600, SIZE1, UNUSED,
    0x013B, 0x6700, SIZE1, UNUSED,
    0x013B, 0x6700, SIZE1, UNUSED,
    0x0138, 0x6800, SIZE1, UNUSED,
    0x0138, 0x6800, SIZE1, UNUSED,
    0x0135, 0x6900, SIZE1, UNUSED,
    0x0135, 0x6900, SIZE1, UNUSED,
    0x0132, 0x6A00, SIZE1, UNUSED,
    0x0132, 0x6A00, SIZE1, UNUSED,
    0x012F, 0x6B00, SIZE1, UNUSED,
    0x012F, 0x6B00, SIZE1, UNUSED,
    0x012C, 0x6C00, SIZE1, UNUSED,
    0x012C, 0x6C00, SIZE1, UNUSED,
    0x0129, 0x6D00, SIZE1, UNUSED,
    0x0129, 0x6D00, SIZE1, UNUSED,
    0x0127, 0x6E00, SIZE1, UNUSED,
    0x0127, 0x6E00, SIZE1, UNUSED,
    0x0124, 0x6F00, SIZE1, UNUSED,
    0x0124, 0x6F00, SIZE1, UNUSED,
    0x0121, 0x7000, SIZE1, UNUSED,
    0x0121, 0x7000, SIZE1, UNUSED,
    0x011F, 0x7100, SIZE1, UNUSED,
    0x011F, 0x7100, SIZE1, UNUSED,
    0x011C, 0x7200, SIZE1, UNUSED,
    0x011C, 0x7200, SIZE1, UNUSED,
    0x011A, 0x7300, SIZE1, UNUSED,
    0x011A, 0x7300, SIZE1, UNUSED,
    0x0118, 0x7400, SIZE1, UNUSED,
    0x0118, 0x7400, SIZE1, UNUSED,
    0x0115, 0x7500, SIZE1, UNUSED,
    0x0115, 0x7500, SIZE1, UNUSED,
    0x0113, 0x7600, SIZE1, UNUSED,
    0x0113, 0x7600, SIZE1, UNUSED,
    0x0111, 0x7700, SIZE1, UNUSED,
    0x0111, 0x7700, SIZE1, UNUSED,
    0x010E, 0x7800, SIZE1, UNUSED,
    0x010E, 0x7800, SIZE1, UNUSED,
    0x010C, 0x7900, SIZE1, UNUSED,
    0x010C, 0x7900, SIZE1, UNUSED,
    0x010A, 0x7A00, SIZE1, UNUSED,
    0x010A, 0x7A00, SIZE1, UNUSED,
    0x0108, 0x7B00, SIZE1, UNUSED,
    0x0108, 0x7B00, SIZE1, UNUSED,
    0x0106, 0x7C00, SIZE1, UNUSED,
    0x0106, 0x7C00, SIZE1, UNUSED,
    0x0104, 0x7D00, SIZE1, UNUSED,
    0x0104, 0x7D00, SIZE1, UNUSED,
    0x0102, 0x7E00, SIZE1, UNUSED,
    0x0102, 0x7E00, SIZE1, UNUSED,
    0x0100, 0x7F00, SIZE1, UNUSED,
    0x0100, 0x7F00, SIZE1, UNUSED,
};