


CAL(1)                   USER COMMANDS                     CAL(1)



NAME
     cal - display a calendar

SYNOPSIS
     cal [ options ] [ [ _n_u_m__m_o_n_t_h ] _y_e_a_r ]
     cal [ options ] [ [ _w_o_r_d__m_o_n_t_h ] _y_e_a_r ]

DESCRIPTION
     cal is an enhanced version of the Unix cal command.   It  is
     compatible  to  the  Unix  version  in that it uses the same
     input arguments and its output may be  piped  or  redirected
     anywhere.

     cal displays a calendar for a specified  year,  a  specified
     month  and  year,  or  for the current date.  By default, it
     displays a calendar for the current system-date month,  with
     the current day hilighted.  It correctly handles the transi-
     tion from the Julian to  Gregorian  calendars  in  September
     1752.

ARGUMENTS
     A verbally-specified month may be entered without specifying
     a  year  in  the  argument list; however, a single numerical
     argument will be interpreted as a year.  Only  the  first  3
     characters   of   the  month  name  are  significant  for  a
     verbally-specified month.  The command `cal 10' refers to 10
     AD, not October, and not 1910.

     The options are explained more  fully  in  the  ENHANCEMENTS
     sections below.  The available options are:

     -nod[ata]
          Do not try to read any appointment data file.

     -d[ata-file]=filename
          Read appointments from `filename' (default  appointment
          data  filename  depends  on operating system).  You may
          use -d up to 8 times in a commandline to specify multi-
          ple data file names.

     -f[uture]
          If current month is displayed, then  show  only  future
          appointments  from  the  appointment file, not appoint-
          ments that are past. NOTE:  This switch was -d in  pre-
          vious versions.

     -t[oday]
          If current month is displayed, then show only  appoint-
          ments for today from the appointment file.

     -e[urope]
          Use European format (first weekday is Monday).



Sun Release 4.1   Last change: 11 January 1996                  1






CAL(1)                   USER COMMANDS                     CAL(1)



     -m[axappts]
          Maximum number of appointments to display.  Minimum  is
          8, maximum is 50, default is 24.

     -p[ause]
          Pause before exiting and prompt for a keystroke.

     -8[bit]
          Allows the use 8 bit extended  ASCII  (code  page  437)
          characters  in  Unix  version.  It is always allowed in
          DOS and OS/2 versions

     -noc[olor]
          Inhibit the use of colors.

     -c[olor-file]=filename
          Read color definitions from `filename'  (default  color
          filename depends on operating system).

COMMAND EXAMPLES
     cal -f -d=my_dates
          display  the  current  month  and  future  appointments
          defined in file `my_dates'

     cal 1996
          display the entire year of 1996

     cal 9 1752
          display the month of September 1752

     cal sep 1752
          same as above

     cal January
          display January of the current year

     cal help
          help message displayed for unrecognized arguments

ENHANCEMENTS OVER STANDARD `CAL' COMMAND
     If displaying the single-month format, cal will look  for  a
     date file (the default file or whatever you specify with the
     -d option).  If found, cal will read the file,  looking  for
     special  date  descriptions  for  that  month  which will be
     displayed to the right of the calendar.  By default,  up  to
     24  appointments  (number  may  be  changed  with -m) may be
     displayed per month.  If the current date happens to fall on
     one  of these special dates, it will be flagged by an aster-
     isk.  If there is room, appointments for the next month  may
     also  be  displayed  (next  month's dates having definitions
     like "2nd Thursday" will be skipped).




Sun Release 4.1   Last change: 11 January 1996                  2






CAL(1)                   USER COMMANDS                     CAL(1)



     The special date descriptions specified in the date file are
     single lines, formatted as follows:

      YYYY MM DD NW xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

     where

     YYYY is the year,

     MM   is the month (01 - 12),

     DD   is the day (00 if the NW field is used),

     NW   is the weekday-of-month code (00 if  the  DD  field  is
          used)

     xxxx is the description; it will be truncated  as  necessary
          to fit

     The data MUST occupy the character fields as shown.  If YYYY
     is  specified  as  -999, the month and day are assumed to be
     annual events such as holidays, and the description will  be
     displayed  for  any year.  If MM is specified as -9, the day
     is assumed to be a monthly event for the specified year.  In
     the weekday-of-month code NW, N signifies on which weekday W
     the special date occurs.   For  example,  31  indicates  the
     third  sunday.  Values of W range from 1 to 7, for Sunday to
     Saturday, respectively.  A value of 9 for N indicates "last"
     as in 95 for "last thursday."

     If ALL of the fields contain a positive number and the  year
     is  at  least  1970,  then  the description is assumed to be
     periodic, starting at the given date,  with  the  period  in
     days  specified  in  NW (e.g. 1995 01 06 14 will display the
     description every 2nd Friday using 6  January  1995  as  the
     base date).  The base date does not get displayed.

     You can display birthdays and anniversaries by  putting  the
     year  of  birth  (or other special event) inside brackets or
     braces, in the description.  This number is converted to the
     number of years since the year you indicate and the brackets
     or braces are removed from the output.   If  braces  {}  are
     used  the  number  will  have an ordinal suffix, as in 21st,
     32nd, 43rd, 54th, etc.  If the number in brackets or  braces
     is  greater  than  the  current  year,  the  number  will be
     displayed unchanged.  Example: "Alex's {1961} birthday" will
     display  as  "Alex's  34th birthday" (if the current year is
     1995).  If you need to include brackets or  braces  in  your
     output  then you can escape them by prefixing it with a '\'.
     Example: "Alex's \{1961\} birthday"  will  be  displayed  as
     "Alex's {1961} birthday".




Sun Release 4.1   Last change: 11 January 1996                  3






CAL(1)                   USER COMMANDS                     CAL(1)



     NOTE:  If cal is invoked with the -europe switch, then the W
     values  1-7  denote  Monday(1) to Sunday(7) rather than Sun-
     day(1) to Saturday(7).

     A line in cal.dat must start with -999 or a  4-digit  number
     to  be  considered  as  data.   The data lines may be in any
     order.  All these appointments will be displayed in  chrono-
     logical order, regardless of the ordering in the appointment
     data file.

     If compiled with the USE_REMINDER flag, cal will also search
     for the files _d_a_t_e_s and ._d_a_t_e_s in the same places as for the
     _c_a_l_d_a_t equivalents.  The _d_a_t_e_s file  is  used  by  the  rem-
     inder(1)  program  and is an alternate, less-powerful format
     for specifying descriptions.  A file in this  format  cannot
     be specified with the -data-file= option.

     The reminder format consists  of  text  lines  of  length  <
     screen width in the following format:

       DDDDDDDD:N:xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx:yyyyyy:S

     where

     DDDDDDDD
          is the date in one of the following formats:

      M/D/Y
          an event occurring on a specific day (year can  be  two
          or  four  digits, but must be two for backward compati-
          bility with reminder)

      M/D an event occurring every year

      D   an event occurring every month

      DDD an event occurring every  week  (day  of  the  week  is
          'Sun', 'Mon', etc.)

     N    is the number of days notice of the event to  give  the
          user (ignored by cal)

     xxxxx
          the event description

     yyyyy
          an optional receptor of the event (e.g. Mr. Jones)

     S    status flag, either N for  normal  event  or  D  for  a
          deleted (not displayed) event





Sun Release 4.1   Last change: 11 January 1996                  4






CAL(1)                   USER COMMANDS                     CAL(1)



     Blank lines are ignored.  A line otherwise not in the  above
     format  is  assume to specify a file name from which to read
     more events.  The file is searched for in the usual places.

     The -f commandline switch causes any date description  older
     than  today's  date  to  be ignored, thereby giving room for
     other descriptions with future dates to  be  displayed.   As
     time progresses through the month, old descriptions are dis-
     carded and newer ones are used.  The -f switch affects  only
     the display for the current month, and not other months.

     There is an optional environment variable that can  be  used
     by cal if found.  If CALOPT is set then cal will read it and
     use any valid command line options found.  This  allows  any
     commonly  used  switches  to  be set in your environment and
     always used (e.g. -europe).   Cal  will  produce  its  usage
     screen when run if any invalid options are set in this vari-
     able.

ENHANCEMENTS SPECIFIC TO MS-DOS and OS/2
     Under MS-DOS or OS/2, commandline arguments may begin with a
     '/' instead of a '-' character.  It works either way.

     The default name for the date file under MS-DOS and OS/2  is
     called  _c_a_l._d_a_t.  It will first look for this file (or what-
     ever you specify with the -d option) in the  current  direc-
     tory  and  if  that fails it will look in the directory that
     the cal program is located in.

     cal modifies the display attributes  behind  its  output  in
     order to display the calendar in attractive colors.  Display
     manipulation is not done if cal's output is redirected to  a
     file.   When  cal  starts  up,  it  looks  for a file called
     _c_a_l._c_o_l (or whatever you specify with the -c option),  first
     in  cal's  originating  directory,  and  then in the current
     directory.  The colors have their own defaults if  the  file
     is not found.

ENHANCEMENTS SPECIFIC TO UNIX
     Under  Unix  the  default  filenames  and  places  that  are
     searched for are different.  For the calendar date file, cal
     searches for the file ._c_a_l_d_a_t in the users  home  directory.
     If it is not found cal will then look for the file _c_a_l_d_a_t in
     the current directory and then look for it in /usr/lib.

     For the default color file, it will look first in the user's
     home directory for the file ._c_a_l_c_o_l.  It then looks for _c_a_l_-
     _c_o_l in the current directory and then in /usr/lib.

COLOR ATTRIBUTES
     Example of a color definition file:




Sun Release 4.1   Last change: 11 January 1996                  5






CAL(1)                   USER COMMANDS                     CAL(1)



      15 02   video colors for month name
      01 03   video colors for weekday header
      07 01   video colors for normal calendar days
      13 01   video colors for sundays
      14 02   video colors for current day
      07 06   bkgd for yearly calendar (space between months)
      11 00   video colors for special day descriptions
      12 08   video colors for * indicating descr.=today

     FG BG

     Color definitions must appear as above, as  a  two-character
     field  for  the  foreground color, followed by a space, fol-
     lowed by a two-character field  for  the  background  color.
     The color definitions must start on the first line, and must
     not contain blank lines.   Comments  may  appear  after  the
     second  field,  provided that the total line length does not
     exceed 80 characters.

     Possible colors:

       black           0
       blue            1
       green           2
       cyan            3
       red             4
       violet          5
       orange          6
       light gray      7

       dark gray       8
       bright blue     9
       bright green    10
       bright cyan     11
       bright red      12
       bright violet   13
       yellow          14
       white           15

     Specifying a background color from 8 to 15 will result in  a
     background color of 0 to 7, with flashing text.

FILES
     cal.dat             DOS and OS/2 date file
     cal.col             DOS and OS/2 color file
     ~/.caldat           Unix local date file
     ~/.calcol           Unix local color file
     caldat
     /usr/lib/caldat     Unix global date files
     calcol
     /usr/lib/calcol     Unix global color files
     ~/.dates            date  file  used  with   Unix   reminder



Sun Release 4.1   Last change: 11 January 1996                  6






CAL(1)                   USER COMMANDS                     CAL(1)



                         program and can be used with cal.

AUTHOR
          Alex Matulich  -  matulich_a@seaa.navsea.navy.mil

          ...with enhancements and modifications by other
          contributors.

          (c) 1995 by Unicorn Research Corporation.  All rights
          reserved.  Inspired by an Amiga program by
          Gary L. Brant.

SEE ALSO
     date(1), reminder(1), rs(1)









































Sun Release 4.1   Last change: 11 January 1996                  7



