/* Copyright (C) 2014 Chris Vine

The library comprised in this file or of which this file is part is
distributed by Chris Vine under the GNU Lesser General Public
License as follows:

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License, version 2.1, for more details.

   You should have received a copy of the GNU Lesser General Public
   License, version 2.1, along with this library (see the file LGPL.TXT
   which came with this source code package in the c++-gtk-utils
   sub-directory); if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <tuple>

#include <c++-gtk-utils/param.h>
#include <c++-gtk-utils/cgu_config.h>

using namespace Cgu;

int add(const int&i, int& j, int k, int l) {
  ++j;
  return i + j + k + l;
}

class Test {
  int a;
public:
  int add(const int&i, int& j, int k, int l) {
    ++j;
    return a + i + j + k + l;
  }
  int add(const int&i, int& j, int k, int l) const {
    ++j;
    return a + i + j + k + l;
  }
  Test(): a(1) {}
};

typedef std::tuple<const int&, int&, int> TupleType1;
typedef std::tuple<const int&, int, int> TupleType2;

extern "C" {
static void test_tuple() {
#ifdef CGU_USE_TUPLE
  
  int i = 0;
  const int ci = 2;

  TupleType1 t1{ci, i, 3};
  const TupleType1 ct1{ci, i, 3};
  TupleType2 t2{ci, i, 3};

  /* non-const lvalue tuple, plain function */
  int res = tuple_apply(&add, t1, 1);
  g_assert_cmpint(res, ==, 7);
  g_assert_cmpint(i, ==, 1);

  /* const lvalue tuple, plain function */
  i = 0;
  // const is top level only - we should be able to modify i through a
  // const tuple via a non-const reference to int type
  res = tuple_apply(&add, ct1, 1);
  g_assert_cmpint(res, ==, 7);
  g_assert_cmpint(i, ==, 1);

  /* non-const lvalue tuple, plain function, with t2 */
  i = 0;
  // here we increment the second item of the tuple t2 (which is held
  // by value and was initialised as 0), but not i
  res = tuple_apply(&add, t2, 1);
  g_assert_cmpint(res, ==, 7);
  g_assert_cmpint(i, ==, 0);
  g_assert_cmpint(std::get<1>(t2), ==, 1);

  /* rvalue tuple, plain function */
  res = tuple_apply(&add, TupleType1{ci, i, 3}, 1);
  g_assert_cmpint(res, ==, 7);
  g_assert_cmpint(i, ==, 1);

  Test test;
  /* non-const lvalue tuple, member function */
  i = 0;
  res = tuple_apply(test, &Test::add, t1, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 1);
  
  /* const lvalue tuple, member function */
  i = 0;
  // const is top level only - we should be able to modify i through a
  // const tuple via a non-const reference to int type
  res = tuple_apply(test, &Test::add, ct1, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 1);
  
  /* non-const lvalue tuple, member function, with t2 */
  i = 0;
  std::get<1>(t2) = 0;
  // here we increment the second item of the tuple t2 (which is held
  // by value set to 0), but not i
  res = tuple_apply(test, &Test::add, t2, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 0);
  g_assert_cmpint(std::get<1>(t2), ==, 1);

  /* rvalue tuple, member function */
  res = tuple_apply(test, &Test::add, TupleType1{ci, i, 3}, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 1);

  const Test ctest;
  /* non-const lvalue tuple, const member function */
  i = 0;
  res = tuple_apply(ctest, &Test::add, t1, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 1);
  
  /* const lvalue tuple, const member function */
  i = 0;
  // const is top level only - we should be able to modify i through a
  // const tuple via a non-const reference to int type
  res = tuple_apply(ctest, &Test::add, ct1, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 1);
  
  /* non-const lvalue tuple, const member function, with t2 */
  i = 0;
  std::get<1>(t2) = 0;
  // here we increment the second item of the tuple t2 (which is held
  // by value set to 0), but not i
  res = tuple_apply(ctest, &Test::add, t2, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 0);
  g_assert_cmpint(std::get<1>(t2), ==, 1);

  /* rvalue tuple, const member function */
  res = tuple_apply(ctest, &Test::add, TupleType1{ci, i, 3}, 1);
  g_assert_cmpint(res, ==, 8);
  g_assert_cmpint(i, ==, 1);

#endif // CGU_USE_TUPLE
}
} // extern "C"


int main (int argc, char* argv[]) {
  g_test_init(&argc, &argv, static_cast<void*>(0));

  g_test_add_func("/tuple/tuple_apply", test_tuple); 

  return g_test_run();
}
