#!/bin/sh

rm -rf autom4te.cache
rm -f config.cache
rm -f configure.ac configure

# it doesn't make any difference whether we pass configure-gtk2.ac,
# configure-gtk3.ac or configure-gtk4.ac to aclocal, automake and
# autoheader (the minor differences between them don't affect the
# output of those tools), but we will copy configure-gtk4.ac to
# configure.ac so any unqualifed calls to autoconf do the right thing
cp configure-gtk4.ac configure.ac
aclocal -I m4
libtoolize
autoheader
automake --add-missing
autoconf -o configure-gtk4

# make configure-gtk4 the default if the user calls 'configure'
cp configure-gtk4 configure

cd po
for lang in `cat LINGUAS`; do msgfmt $lang.po; mv messages.mo $lang.gmo; done
cd ..

./configure $@
